/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.directional;

import com.conquestreforged.content.blocks.util.Interactions;
import com.conquestreforged.core.asset.annotation.ItemDescription;
import com.conquestreforged.core.block.base.DirectionalShape;
import com.conquestreforged.core.block.base.WaterloggedDirectionalShape;
import com.conquestreforged.core.block.builder.Props;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Directional
extends DirectionalShape {
    private final List<VoxelShape> hitBox;

    public Directional(Props props) {
        super(props.toSettings());
        this.hitBox = props.get("hitBox", List.class);
    }

    @Override
    public VoxelShape getShape(BlockState state) {
        return Directional.getVoxelShape(this.hitBox, state, DIRECTION);
    }

    private static VoxelShape getVoxelShape(List<VoxelShape> hitBox, BlockState state, DirectionProperty direction) {
        boolean hasSixShapes = hitBox.size() == 6;
        return switch ((Direction)state.m_61143_((Property)direction)) {
            case Direction.EAST -> hitBox.get(hasSixShapes ? 1 : 0);
            case Direction.SOUTH -> hitBox.get(hasSixShapes ? 2 : 0);
            case Direction.WEST -> hitBox.get(hasSixShapes ? 3 : 0);
            case Direction.UP -> hitBox.get(hasSixShapes ? 4 : 0);
            case Direction.DOWN -> hitBox.get(hasSixShapes ? 5 : 0);
            default -> hitBox.get(0);
        };
    }

    @ItemDescription(description="toggle_2")
    public static class WaterloggedToggle2
    extends Waterlogged {
        public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)2);

        public WaterloggedToggle2(Props props) {
            super(props);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE});
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
        }
    }

    @ItemDescription(description="toggle_2")
    public static class Toggle2
    extends Directional {
        public static final IntegerProperty TOGGLE = IntegerProperty.m_61631_((String)"toggle", (int)1, (int)2);

        public Toggle2(Props props) {
            super(props);
        }

        @Override
        protected void addProperties(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{TOGGLE});
        }

        public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
            return Interactions.onUseToggleItem(player, level, blockPos, state, TOGGLE);
        }
    }

    public static class Waterlogged
    extends WaterloggedDirectionalShape {
        private final List<VoxelShape> hitBox;

        public Waterlogged(Props props) {
            super(props.toSettings());
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            this.hitBox = props.get("hitBox", List.class);
        }

        @Override
        public VoxelShape getShape(BlockState state) {
            return Directional.getVoxelShape(this.hitBox, state, DIRECTION);
        }
    }
}

