/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.block.trees;

import com.conquestreforged.content.effects.EffectsInit;
import com.conquestreforged.core.asset.annotation.Render;
import com.conquestreforged.core.block.builder.Props;
import com.conquestreforged.core.util.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@Render(value=RenderLayer.CUTOUT_MIPPED)
public class LeavesFruit
extends CropBlock {
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    private final ItemLike fruit;

    public LeavesFruit(Props props) {
        super(props.toSettings());
        this.fruit = props.get("fruit", ItemLike.class);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52244_, (Comparable)Integer.valueOf(0)));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player) {
                livingEntity.m_7292_(new MobEffectInstance(EffectsInit.CUSTOM_SLOWNESS, 15, 12, false, false));
            } else {
                livingEntity.m_7292_(new MobEffectInstance(EffectsInit.CUSTOM_SLOWNESS, 15, 6, false, false));
            }
        }
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() || (Integer)state.m_61143_((Property)DISTANCE) == 7) {
            // empty if block
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState state1, LevelAccessor world, BlockPos pos, BlockPos pos1) {
        int i = LeavesFruit.getDistance(state1) + 1;
        if (i != 1 || (Integer)state.m_61143_((Property)DISTANCE) != i) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos blockPosMutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            blockPosMutable.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, LeavesFruit.getDistance(worldIn.m_8055_((BlockPos)blockPosMutable)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistance(BlockState neighbor) {
        if (neighbor.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return neighbor.m_60734_() instanceof LeavesBlock || neighbor.m_60734_() instanceof LeavesFruit ? (Integer)neighbor.m_61143_((Property)DISTANCE) : 7;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateList) {
        stateList.m_61104_(new Property[]{DISTANCE, PERSISTENT, f_52244_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return LeavesFruit.updateDistance((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return true;
    }

    public boolean m_6266_(BlockState p_200014_1_, BlockGetter p_200014_2_, BlockPos p_200014_3_) {
        return true;
    }

    public ItemStack m_7397_(BlockGetter reader, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this, 1);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.m_52307_(state)) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            state = (BlockState)state.m_61124_((Property)f_52244_, (Comparable)Integer.valueOf(0));
            level.m_7731_(blockPos, state, 3);
            this.dropFruit(level, blockPos, state);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void dropFruit(Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            float f = 0.7f;
            double d0 = (double)(world.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            double d1 = (double)(world.f_46441_.m_188501_() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(world.f_46441_.m_188501_() * 0.7f) + (double)0.15f;
            ItemStack itemstack1 = new ItemStack(this.fruit, 1);
            ItemEntity entityitem = new ItemEntity(world, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, itemstack1);
            entityitem.m_32060_();
            world.m_7967_((Entity)entityitem);
        }
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.NONE;
    }
}

