/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.group;

import com.conquestreforged.core.item.family.FamilyGroup;
import com.conquestreforged.core.item.group.ConquestItemGroup;
import com.conquestreforged.core.item.group.manager.ItemGroupManager;
import com.conquestreforged.core.util.Provider;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModGroups {
    public static final ConquestItemGroup WINDOWS_AND_GLASS = ModGroups.createFamilyGroup(10, "ff_windows_and_glass", ModGroups.block("minecraft:glass"));
    public static final ConquestItemGroup CLOTH_AND_FIBERS = ModGroups.createFamilyGroup(11, "g_cloth_and_fibers", ModGroups.block("conquest:magenta_carpet"));
    public static final ConquestItemGroup FURNITURE = ModGroups.createFamilyGroup(12, "gg_furniture", ModGroups.block("conquest:old_rustic_bed"));
    public static final ConquestItemGroup APPLIANCES = ModGroups.createFamilyGroup(13, "h_appliances", ModGroups.block("minecraft:loom"));
    public static final ConquestItemGroup STORAGE = ModGroups.createFamilyGroup(14, "hh_storage", ModGroups.block("conquest:rounded_chest"));
    public static final ConquestItemGroup DECORATIONS = ModGroups.createFamilyGroup(15, "i_decor", ModGroups.block("conquest:towel_rack"));
    public static final ConquestItemGroup POTTERY = ModGroups.createFamilyGroup(15, "ia_pottery", ModGroups.block("conquest:terracotta_urn"));
    public static final ConquestItemGroup LIGHTING = ModGroups.createFamilyGroup(16, "ii_lighting", ModGroups.block("conquest:small_lantern"));
    public static final ConquestItemGroup TOOL_BLOCKS = ModGroups.createFamilyGroup(17, "j_tool_blocks", ModGroups.block("conquest:rack_of_pitchforks_scythes_and_flails"));
    public static final ConquestItemGroup FOOD_BLOCKS = ModGroups.createFamilyGroup(18, "jj_food_blocks", ModGroups.block("conquest:big_bread"));
    public static final ConquestItemGroup STONE = ModGroups.createFamilyGroup(19, "k_stone", ModGroups.block("conquest:mudstone"));
    public static final ConquestItemGroup GRASS_AND_DIRT = ModGroups.createFamilyGroup(20, "kk_grass_and_dirt", ModGroups.block("minecraft:grass_block"));
    public static final ConquestItemGroup SAND_AND_GRAVEL = ModGroups.createFamilyGroup(21, "l_sand_and_gravel", ModGroups.block("conquest:small_stones"));
    public static final ConquestItemGroup LOGS = ModGroups.createFamilyGroup(22, "ll_logs", ModGroups.block("minecraft:oak_log"));
    public static final ConquestItemGroup LEAVES = ModGroups.createFamilyGroup(23, "m_leaves", ModGroups.block("minecraft:dark_oak_leaves"));
    public static final ConquestItemGroup GRASSES_AND_SHRUBS = ModGroups.createFamilyGroup(24, "mm_grasses_and_shrubs", ModGroups.block("minecraft:grass"));
    public static final ConquestItemGroup FLOWERS = ModGroups.createFamilyGroup(25, "n_flowers", ModGroups.block("conquest:hanging_dandelions"));
    public static final ConquestItemGroup CROPS = ModGroups.createFamilyGroup(26, "nn_crops_and_herbs", ModGroups.block("conquest:wild_wheat"));
    public static final ConquestItemGroup WATER_AND_AIR = ModGroups.createFamilyGroup(27, "o_water_and_air", ModGroups.block("conquest:steam"));
    public static final ConquestItemGroup ANIMALS = ModGroups.createFamilyGroup(28, "oo_animals", ModGroups.block("conquest:owl"));
    public static final ConquestItemGroup ARMOR = ModGroups.createFamilyGroup(29, "p_armor", ModGroups.item("minecraft:chainmail_chestplate"));
    public static final ConquestItemGroup WEAPONS_AND_TOOLS = ModGroups.createFamilyGroup(30, "pp_weapons_and_tools", ModGroups.item("minecraft:iron_axe"));
    public static final ConquestItemGroup FOOD_AND_CONSUMABLES = ModGroups.createFamilyGroup(31, "q_food_and_consumables", ModGroups.item("minecraft:bread"));
    public static final ConquestItemGroup BREWING = ModGroups.createFamilyGroup(32, "qq_brewing", ModGroups.block("minecraft:brewing_stand"));
    public static final ConquestItemGroup MISCELLANEOUS = ModGroups.createFamilyGroup(33, "r_miscellaneous", ModGroups.item("minecraft:music_disc_strad"));
    public static final ConquestItemGroup UTILITY = ModGroups.createFamilyGroup(34, "rr_utility", ModGroups.block("minecraft:barrier"));
    private static CreativeModeTab.Row rowValue = CreativeModeTab.Row.TOP;

    public static void initGroups() {
        FamilyGroup.stream().forEach(familyGroup -> ItemGroupManager.getInstance().register((ConquestItemGroup)((Object)familyGroup)));
    }

    private static Supplier<ItemStack> block(String name) {
        return Provider.block(name).toStack();
    }

    private static Supplier<ItemStack> item(String name) {
        return Provider.item(name).toStack();
    }

    private static void toggleRow(int order) {
        if (order % 5 == 0) {
            if (rowValue == CreativeModeTab.Row.TOP) {
                rowValue = CreativeModeTab.Row.BOTTOM;
            } else if (rowValue == CreativeModeTab.Row.BOTTOM) {
                rowValue = CreativeModeTab.Row.TOP;
            }
        }
    }

    private static FamilyGroup createFamilyGroup(int order, String label, Supplier<ItemStack> icon) {
        ResourceKey groupKey = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("conquest", label));
        ModGroups.toggleRow(order);
        FamilyGroup group = new FamilyGroup(order, label, icon, rowValue, order % 5 + 1, CreativeModeTab.Type.CATEGORY, Component.m_130674_((String)label), (displayContext, entries) -> {});
        return group;
    }

    @SubscribeEvent
    public static void registerItemGroups(RegisterEvent event) {
        event.register(BuiltInRegistries.f_279662_.m_123023_(), itemGroupRegisterHelper -> FamilyGroup.stream().forEach(familyGroup -> itemGroupRegisterHelper.register(new ResourceLocation("conquest", familyGroup.label), (Object)familyGroup)));
    }
}

