/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.util;

import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CauldronBehavior {
    public static final BooleanProperty OFFSET_TOGGLE = ModBlockProperties.OFFSET_TOGGLE;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    private final List<VoxelShape> hitBox;

    public CauldronBehavior(List<VoxelShape> hitBox) {
        this.hitBox = hitBox;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public VoxelShape getOutlineShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.hitBox.get(0);
    }

    public boolean calculateSlabOffset(Direction facing, Block block, BlockState state, BlockPlaceContext context) {
        if (facing == Direction.DOWN) {
            return block instanceof Slab || block instanceof SlabBlock || block instanceof Layer || block instanceof SnowLayerBlock || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        }
        if (facing != Direction.UP) {
            return block instanceof VerticalSlab && state.m_61143_((Property)VerticalSlab.DIRECTION) == context.m_43719_();
        }
        return false;
    }

    public void onEntityCollision(BlockState state, Level world, BlockPos pos, Entity entity) {
        int level = (Integer)state.m_61143_((Property)LEVEL);
        float waterLevel = (float)pos.m_123342_() + (6.0f + (float)(3 * level)) / 16.0f;
        if (!world.f_46443_ && entity.m_6060_() && level > 0 && entity.m_20186_() <= (double)waterLevel) {
            entity.m_20095_();
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level - 1)));
        }
    }

    public InteractionResult onUse(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return InteractionResult.PASS;
        }
        int waterLevel = (Integer)state.m_61143_((Property)LEVEL);
        Item item = itemStack.m_41720_();
        if (item == Items.f_42447_) {
            return this.handleWaterBucket(state, level, blockPos, player, hand, waterLevel);
        }
        if (item == Items.f_42446_) {
            return this.handleEmptyBucket(state, level, blockPos, player, hand, itemStack, waterLevel);
        }
        if (item == Items.f_42590_) {
            return this.handleGlassBottle(state, level, blockPos, player, hand, itemStack, waterLevel);
        }
        if (item == Items.f_42589_ && PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43599_) {
            return this.handleWaterPotion(state, level, blockPos, player, hand, waterLevel);
        }
        return this.handleCleaningInteractions(state, level, blockPos, player, hand, itemStack, item, waterLevel);
    }

    private InteractionResult handleWaterBucket(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, int waterLevel) {
        if (waterLevel < 3 && !level.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
            player.m_36220_(Stats.f_12943_);
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(3)));
            level.m_5594_(null, blockPos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult handleEmptyBucket(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack, int waterLevel) {
        if (waterLevel == 3 && !level.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
                if (itemStack.m_41619_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
                } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42447_))) {
                    player.m_36176_(new ItemStack((ItemLike)Items.f_42447_), false);
                }
            }
            player.m_36220_(Stats.f_12944_);
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
            level.m_5594_(null, blockPos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult handleGlassBottle(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack, int waterLevel) {
        if (waterLevel > 0 && !level.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                ItemStack waterBottle = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_);
                player.m_36220_(Stats.f_12944_);
                itemStack.m_41774_(1);
                if (itemStack.m_41619_()) {
                    player.m_21008_(hand, waterBottle);
                } else if (!player.m_150109_().m_36054_(waterBottle)) {
                    player.m_36176_(waterBottle, false);
                } else if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_36095_.m_150429_();
                }
            }
            level.m_5594_(null, blockPos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult handleWaterPotion(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, int waterLevel) {
        if (waterLevel < 3 && !level.f_46443_) {
            if (!player.m_150110_().f_35937_) {
                ItemStack glassBottle = new ItemStack((ItemLike)Items.f_42590_);
                player.m_36220_(Stats.f_12944_);
                player.m_21008_(hand, glassBottle);
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_36095_.m_150429_();
                }
            }
            level.m_5594_(null, blockPos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(waterLevel + 1)));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private InteractionResult handleCleaningInteractions(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack, Item item, int waterLevel) {
        DyeableArmorItem dyeableItem;
        if (waterLevel <= 0) {
            return InteractionResult.PASS;
        }
        if (item instanceof DyeableArmorItem && (dyeableItem = (DyeableArmorItem)item).m_41113_(itemStack) && !level.f_46443_) {
            dyeableItem.m_41123_(itemStack);
            level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
            player.m_36220_(Stats.f_12945_);
            return InteractionResult.SUCCESS;
        }
        if (item instanceof BannerItem) {
            if (BannerBlockEntity.m_58504_((ItemStack)itemStack) > 0 && !level.f_46443_) {
                ItemStack cleanBanner = itemStack.m_41777_();
                cleanBanner.m_41764_(1);
                BannerBlockEntity.m_58509_((ItemStack)cleanBanner);
                player.m_36220_(Stats.f_12946_);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                    level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
                }
                if (itemStack.m_41619_()) {
                    player.m_21008_(hand, cleanBanner);
                } else if (!player.m_150109_().m_36054_(cleanBanner)) {
                    player.m_36176_(cleanBanner, false);
                } else if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).f_36095_.m_150429_();
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof ShulkerBoxBlock && !level.m_5776_()) {
                ItemStack cleanShulkerBox = new ItemStack((ItemLike)Blocks.f_50456_, 1);
                if (itemStack.m_41782_()) {
                    cleanShulkerBox.m_41751_(itemStack.m_41783_().m_6426_());
                }
                player.m_21008_(hand, cleanShulkerBox);
                level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
                player.m_36220_(Stats.f_12947_);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void precipitationTick(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        BlockState currentState;
        float temperature;
        if (world.f_46441_.m_188503_(20) == 1 && (temperature = ((Biome)world.m_204166_(pos).m_203334_()).m_47554_()) >= 0.15f && (Integer)(currentState = world.m_8055_(pos)).m_61143_((Property)LEVEL) < 3) {
            world.m_7731_(pos, (BlockState)currentState.m_61122_((Property)LEVEL), 2);
        }
    }

    public boolean hasComparatorOutput(BlockState state) {
        return true;
    }

    public int getComparatorOutput(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL);
    }
}

