/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.util;

import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import com.conquestreforged.content.blocks.tileentity.seat.SeatTileEntity;
import com.conquestreforged.content.entities.seat.SeatEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBehavior {
    public static final BooleanProperty OFFSET_TOGGLE = ModBlockProperties.OFFSET_TOGGLE;
    private final double chairHeight;

    public ChairBehavior(double chairHeight) {
        this.chairHeight = chairHeight;
    }

    public double getSeatHeight() {
        return this.chairHeight;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context, VoxelShape defaultShape) {
        if (((Boolean)state.m_61143_((Property)OFFSET_TOGGLE)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return defaultShape;
    }

    public boolean calculateSlabOffset(Direction facing, Block block, BlockState state, BlockPlaceContext context) {
        if (facing == Direction.DOWN) {
            return block instanceof Slab || block instanceof SlabBlock || block instanceof Layer || block instanceof SnowLayerBlock || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        }
        if (facing != Direction.UP) {
            return block instanceof VerticalSlab && state.m_61143_((Property)VerticalSlab.DIRECTION) == context.m_43719_();
        }
        return false;
    }

    public InteractionResult handleSittingInteraction(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult, FallbackAction fallbackAction, Integer maxToggleValue) {
        SeatTileEntity seat = (SeatTileEntity)level.m_7702_(blockPos);
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            return fallbackAction.execute();
        }
        if (maxToggleValue != null && state.m_61138_((Property)this.getToggleProperty(state))) {
            int toggleValue = (Integer)state.m_61143_((Property)this.getToggleProperty(state));
            if (toggleValue <= maxToggleValue) {
                return this.createNewSeat(seat, player, level, blockPos);
            }
            return fallbackAction.execute();
        }
        List seats = level.m_45976_(SeatEntity.class, new AABB(blockPos));
        if (!seats.isEmpty()) {
            SeatEntity seatEntity = (SeatEntity)((Object)seats.get(0));
            List passengers = seatEntity.m_20197_();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return InteractionResult.SUCCESS;
            }
            seatEntity.m_20153_();
            boolean success = player.m_20329_((Entity)seatEntity);
            if (success) {
                level.m_6289_(blockPos, level.m_8055_(blockPos).m_60734_());
                seat.m_6596_();
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return this.createNewSeat(seat, player, level, blockPos);
    }

    private InteractionResult createNewSeat(SeatTileEntity seat, Player player, Level level, BlockPos blockPos) {
        boolean success = seat.rideSeat(player);
        if (success) {
            level.m_6289_(blockPos, level.m_8055_(blockPos).m_60734_());
            seat.m_6596_();
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private IntegerProperty getToggleProperty(BlockState state) {
        for (Property property : state.m_61147_()) {
            if (!property.m_61708_().equals("toggle")) continue;
            return (IntegerProperty)property;
        }
        return null;
    }

    public BlockEntity createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new SeatTileEntity(blockPos, blockState);
    }

    @FunctionalInterface
    public static interface FallbackAction {
        public InteractionResult execute();
    }
}

