/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.content.blocks.util;

import com.conquestreforged.content.blocks.block.BoardsHorizontal;
import com.conquestreforged.content.blocks.block.Layer;
import com.conquestreforged.content.blocks.block.Slab;
import com.conquestreforged.content.blocks.block.SlabLessLayers;
import com.conquestreforged.content.blocks.block.VerticalSlab;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class PlacementHelper {
    public static boolean replacingClickedOnBlock(BlockPlaceContext context) {
        if (context instanceof DirectionalPlaceContext) {
            return false;
        }
        return context.m_7058_();
    }

    public static boolean isDuringWorldGen(BlockGetter reader) {
        return !(reader instanceof Level);
    }

    public static Direction getHitVecHorizontalAxisDirection(Direction facing, BlockPos pos, BlockPlaceContext context) {
        switch (facing) {
            case NORTH: {
                return !(context.m_43720_().f_82479_ - (double)pos.m_123341_() > 0.5) ? facing.m_122427_() : facing;
            }
            case SOUTH: {
                return !(context.m_43720_().f_82479_ - (double)pos.m_123341_() < 0.5) ? facing.m_122427_() : facing;
            }
            case EAST: {
                return !(context.m_43720_().f_82481_ - (double)pos.m_123343_() > 0.5) ? facing.m_122427_() : facing;
            }
        }
        return !(context.m_43720_().f_82481_ - (double)pos.m_123343_() < 0.5) ? facing.m_122427_() : facing;
    }

    public static int getOrdinalDirection(BlockPlaceContext ctx, int ordinalState) {
        Player player = ctx.m_43723_();
        if (player != null) {
            float yaw = player.m_146908_() % 360.0f;
            if (yaw < 0.0f) {
                yaw += 360.0f;
            }
            boolean isOrdinal = false;
            float tolerance = 25.0f;
            boolean bl = isOrdinal = Math.abs(yaw - 45.0f) <= tolerance || Math.abs(yaw - 135.0f) <= tolerance || Math.abs(yaw - 225.0f) <= tolerance || Math.abs(yaw - 315.0f) <= tolerance;
            if (isOrdinal) {
                return ordinalState;
            }
        }
        return 1;
    }

    public static boolean isFacingSlab(BlockPlaceContext context) {
        Direction facing = context.m_43719_().m_122424_();
        Level blockreader = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = blockreader.m_8055_(pos.m_121945_(facing));
        Block block = state.m_60734_();
        boolean isSlab = false;
        if (facing == Direction.DOWN) {
            isSlab = block instanceof Slab || block instanceof SlabBlock || block instanceof Layer || block instanceof SnowLayerBlock || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        } else if (facing != Direction.UP) {
            isSlab = block instanceof VerticalSlab && state.m_61143_((Property)VerticalSlab.DIRECTION) == context.m_43719_();
        }
        return isSlab;
    }

    public static BlockState mirrorCornerDirection(BlockState state, Mirror mirrorIn, DirectionProperty directionProperty, BiFunction<BlockState, Mirror, BlockState> fallbackMirror) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                switch ((Direction)state.m_61143_((Property)directionProperty)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.EAST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.NORTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.WEST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.SOUTH);
                    }
                }
                return fallbackMirror.apply(state, mirrorIn);
            }
            case LEFT_RIGHT: {
                switch ((Direction)state.m_61143_((Property)directionProperty)) {
                    case NORTH: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.WEST);
                    }
                    case EAST: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.SOUTH);
                    }
                    case SOUTH: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.EAST);
                    }
                    case WEST: {
                        return (BlockState)state.m_61124_((Property)directionProperty, (Comparable)Direction.NORTH);
                    }
                }
                return fallbackMirror.apply(state, mirrorIn);
            }
        }
        return fallbackMirror.apply(state, mirrorIn);
    }
}

