/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.asset.override;

import com.conquestreforged.core.asset.template.JsonOverride;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class SingleOverride
implements JsonOverride {
    private final boolean any;
    private final String key;
    private final JsonElement find;
    private final JsonElement replace;

    public SingleOverride(String key, JsonElement replace) {
        this(key, (JsonElement)new JsonPrimitive("*"), replace);
    }

    public SingleOverride(String key, JsonElement find, JsonElement replace) {
        this.key = key;
        this.find = find;
        this.replace = replace;
        this.any = find.getAsString().equals("*");
    }

    @Override
    public boolean apply(JsonElement input, JsonWriter writer) throws IOException {
        if (this.any || this.find.equals(input)) {
            Streams.write((JsonElement)this.replace, (JsonWriter)writer);
            return true;
        }
        return false;
    }

    @Override
    public boolean appliesTo(String key, JsonElement value) {
        return this.key.equals(key) && value.isJsonPrimitive();
    }
}

