/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.block.builder;

import com.conquestreforged.content.blocks.BlockSettingsAccessor;
import com.conquestreforged.content.blocks.CustomOffsetType;
import com.conquestreforged.core.block.factory.InitializationException;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public abstract class BlockProps<T extends BlockProps<T>> {
    private final Block block;
    private final MapColor color;
    private CustomOffsetType customOffsetType = null;
    private DyeColor dyeColor = null;
    private SoundType sound = null;
    private CreativeModeTab group = CreativeModeTabs.m_258007_();
    private ToIntFunction<BlockState> light = null;
    private Float resistance = null;
    private Float hardness = null;
    private Float slipperiness = null;
    private Boolean randomTick = null;
    private Boolean variableOpacity = null;
    private Boolean dynamicBounds = null;
    private Boolean blocksMovement = null;
    private Boolean solid = null;
    private BlockBehaviour.OffsetType offset = BlockBehaviour.OffsetType.NONE;

    protected BlockProps(Block block) {
        this.block = block;
        this.color = null;
    }

    protected BlockProps(BlockProps<T> props) {
        this.block = props.block;
        this.color = props.color;
        this.dyeColor = props.dyeColor;
        this.sound = props.sound;
        this.group = props.group;
        this.light = props.light;
        this.resistance = props.resistance;
        this.hardness = props.hardness;
        this.slipperiness = props.slipperiness;
        this.randomTick = props.randomTick;
        this.variableOpacity = props.variableOpacity;
        this.blocksMovement = props.blocksMovement;
        this.dynamicBounds = props.dynamicBounds;
        this.solid = props.solid;
        this.offset = props.offset;
    }

    public abstract T getProps();

    public T customOffsetType(CustomOffsetType offsetType) {
        this.customOffsetType = offsetType;
        return this.getProps();
    }

    public T dye(DyeColor color) {
        this.dyeColor = color;
        return this.getProps();
    }

    public T sound(SoundType sound) {
        this.sound = sound;
        return this.getProps();
    }

    public T light(ToIntFunction<BlockState> light) {
        this.light = light;
        return (T)this;
    }

    public T strength(double hardness, double resistance) {
        this.hardness = Float.valueOf((float)hardness);
        this.resistance = Float.valueOf((float)resistance);
        return this.getProps();
    }

    public T slipperiness(double slipperiness) {
        this.slipperiness = Float.valueOf((float)slipperiness);
        return this.getProps();
    }

    public T randomTick(boolean randomTick) {
        this.randomTick = randomTick;
        return this.getProps();
    }

    public T dynamicBounds(boolean dynamicBounds) {
        this.dynamicBounds = dynamicBounds;
        return this.getProps();
    }

    public T opacity(boolean variableOpacity) {
        this.variableOpacity = variableOpacity;
        return this.getProps();
    }

    public T blocking(boolean blocksMovement) {
        this.blocksMovement = blocksMovement;
        return this.getProps();
    }

    public T solid(boolean solid) {
        this.solid = solid;
        return this.getProps();
    }

    public T group(CreativeModeTab group) {
        this.group = group;
        return this.getProps();
    }

    public T offset(BlockBehaviour.OffsetType offsetType) {
        this.offset = offsetType;
        return this.getProps();
    }

    public CreativeModeTab group() {
        return this.group;
    }

    public DyeColor dye() {
        return this.dyeColor == null ? DyeColor.BLACK : this.dyeColor;
    }

    public MapColor color() {
        return this.color == null ? MapColor.f_283927_ : this.color;
    }

    public BlockBehaviour.Properties toSettings() throws InitializationException {
        BlockBehaviour.Properties builder = this.createBuilder();
        BlockProps.applyNonNull(this.sound, arg_0 -> ((BlockBehaviour.Properties)builder).m_60918_(arg_0));
        BlockProps.applyNonNull(this.light, arg_0 -> ((BlockBehaviour.Properties)builder).m_60953_(arg_0));
        BlockProps.applyNonNull(this.slipperiness, arg_0 -> ((BlockBehaviour.Properties)builder).m_60911_(arg_0));
        BlockProps.applyNonNull(this.solid, false, () -> ((BlockBehaviour.Properties)builder).m_60955_());
        BlockProps.applyNonNull(this.randomTick, true, () -> ((BlockBehaviour.Properties)builder).m_60977_());
        BlockProps.applyNonNull(this.dynamicBounds, true, () -> ((BlockBehaviour.Properties)builder).m_60988_());
        BlockProps.applyNonNull(this.variableOpacity, true, () -> ((BlockBehaviour.Properties)builder).m_60988_());
        BlockProps.applyNonNull(this.blocksMovement, false, () -> ((BlockBehaviour.Properties)builder).m_60910_());
        if (this.customOffsetType != null) {
            builder = ((BlockSettingsAccessor)builder).setCustomOffsetter(this.customOffsetType);
        }
        BlockProps.applyNonNull(this.offset, arg_0 -> ((BlockBehaviour.Properties)builder).m_222979_(arg_0));
        if (this.hardness != null && this.resistance != null) {
            builder.m_60913_(this.hardness.floatValue(), this.resistance.floatValue());
        }
        return builder;
    }

    private BlockBehaviour.Properties createBuilder() throws InitializationException {
        BlockBehaviour.Properties props;
        if (this.block != null) {
            props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)this.block);
        } else if (this.color != null) {
            props = BlockBehaviour.Properties.m_284310_().m_284180_(this.color);
        } else {
            throw new InitializationException("Block.Builder requires a Material");
        }
        return props;
    }

    private static <T> void applyNonNull(Boolean value, boolean condition, Runnable runnable) {
        if (value != null && value == condition) {
            runnable.run();
        }
    }

    private static <T> void applyNonNull(T value, Consumer<T> consumer) {
        if (value != null) {
            consumer.accept(value);
        }
    }

    protected abstract <T> void applyNonNull(Integer var1, Consumer<T> var2);
}

