/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.block.factory;

import com.conquestreforged.core.util.OptimizedList;
import com.conquestreforged.core.util.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;

public class TypeList
implements Iterable<Class<? extends Block>>,
Comparator<Block> {
    public static final TypeList EMPTY = new TypeList(Collections.emptyList());
    private static final Cache<TypeKey, TypeList> cache = new TypeListCache();
    private final List<Class<? extends Block>> types;

    private TypeList(List<Class<? extends Block>> types) {
        this.types = types;
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public Class<? extends Block> first() {
        if (this.types.size() > 0) {
            return this.types.get(0);
        }
        return AirBlock.class;
    }

    public static TypeList of(Collection<Class<? extends Block>> types) {
        return new TypeList(new ArrayList<Class<? extends Block>>(types));
    }

    @SafeVarargs
    public static TypeList of(Class<? extends Block> ... types) {
        if (types.length == 0) {
            throw new RuntimeException("No Types provided!");
        }
        return cache.get(new TypeKey(types));
    }

    public TypeList add(Class<? extends Block> type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot add null type to TypeList");
        }
        ArrayList<Class<? extends Block>> newTypes = new ArrayList<Class<? extends Block>>(this.types);
        newTypes.add(type);
        return new TypeList(newTypes);
    }

    public TypeList addAll(Collection<Class<? extends Block>> types) {
        if (types == null || types.isEmpty()) {
            return this;
        }
        ArrayList<Class<? extends Block>> newTypes = new ArrayList<Class<? extends Block>>(this.types);
        newTypes.addAll(types);
        return new TypeList(newTypes);
    }

    @SafeVarargs
    public final TypeList addAll(Class<? extends Block> ... types) {
        if (types == null || types.length == 0) {
            return this;
        }
        return this.addAll(Arrays.asList(types));
    }

    public TypeList remove(Class<? extends Block> type) {
        if (type == null || !this.types.contains(type)) {
            return this;
        }
        ArrayList<Class<? extends Block>> newTypes = new ArrayList<Class<? extends Block>>(this.types);
        newTypes.remove(type);
        if (newTypes.isEmpty()) {
            return EMPTY;
        }
        return new TypeList(newTypes);
    }

    public TypeList removeAll(Collection<Class<? extends Block>> typesToRemove) {
        if (typesToRemove == null || typesToRemove.isEmpty()) {
            return this;
        }
        ArrayList<Class<? extends Block>> newTypes = new ArrayList<Class<? extends Block>>(this.types);
        newTypes.removeAll(typesToRemove);
        if (newTypes.isEmpty()) {
            return EMPTY;
        }
        return new TypeList(newTypes);
    }

    @SafeVarargs
    public final TypeList removeAll(Class<? extends Block> ... types) {
        if (types == null || types.length == 0) {
            return this;
        }
        return this.removeAll(Arrays.asList(types));
    }

    public TypeList replace(Class<? extends Block> oldType, Class<? extends Block> newType) {
        if (oldType == null || newType == null || !this.types.contains(oldType)) {
            return this;
        }
        ArrayList<Class<? extends Block>> newTypes = new ArrayList<Class<? extends Block>>(this.types);
        int index = newTypes.indexOf(oldType);
        newTypes.set(index, newType);
        return new TypeList(newTypes);
    }

    @Override
    public Iterator<Class<? extends Block>> iterator() {
        return this.types.iterator();
    }

    @Override
    public int compare(Block b1, Block b2) {
        return this.getIndex(b1) - this.getIndex(b2);
    }

    private int getIndex(Object o) {
        int max = -1;
        for (int i = 0; i < this.types.size(); ++i) {
            Class<? extends Block> type = this.types.get(i);
            if (!type.isInstance(o)) continue;
            max = Math.max(max, i);
        }
        return max == -1 ? this.types.size() : max;
    }

    private static class TypeKey {
        private final Class<? extends Block>[] types;

        private TypeKey(Class<? extends Block>[] types) {
            this.types = types;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeKey typeKey = (TypeKey)o;
            return Arrays.equals(this.types, typeKey.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }

    private static class TypeListCache
    extends Cache<TypeKey, TypeList> {
        private TypeListCache() {
        }

        @Override
        public TypeList compute(TypeKey typeKey) {
            OptimizedList<Class<? extends Block>> list = OptimizedList.of(typeKey.types);
            list.trim();
            return new TypeList(list);
        }
    }
}

