/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.client.render;

import com.conquestreforged.core.util.RenderLayer;
import com.conquestreforged.core.util.log.Log;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderLayerHelper {
    public static void register(Block block, RenderLayer layer) {
        if (layer != RenderLayer.SOLID && layer != RenderLayer.UNDEFINED) {
            RenderType type = RenderLayerHelper.getType(layer);
            if (type == null) {
                return;
            }
            ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)type);
            Log.debug("Registered render type for Block: {}={}", block.m_49954_().toString(), type);
        }
    }

    public static void register(Fluid fluid, RenderLayer layer) {
        if (layer != RenderLayer.SOLID && layer != RenderLayer.UNDEFINED) {
            RenderType type = RenderLayerHelper.getType(layer);
            if (type == null) {
                return;
            }
            ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)type);
            Log.debug("Registered render type for Fluid: {}={}", BuiltInRegistries.f_257020_.m_7981_((Object)fluid), type);
        }
    }

    private static RenderType getType(RenderLayer layer) {
        switch (layer) {
            case SOLID: {
                return RenderType.m_110451_();
            }
            case CUTOUT: {
                return RenderType.m_110463_();
            }
            case TRANSLUCENT: {
                return RenderType.m_110466_();
            }
            case CUTOUT_MIPPED_SOLID: 
            case CUTOUT_MIPPED: {
                return RenderType.m_110457_();
            }
        }
        return null;
    }
}

