/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockDump {
    public static void run() {
        try (Writer blocks = BlockDump.newWriter("blocks-pls.txt");
             Writer states = BlockDump.newWriter("states-pls.txt");){
            BuiltInRegistries.f_256975_.m_6566_().stream().filter(block -> block.m_135827_().equals("conquest")).sorted(Comparator.comparing(ResourceLocation::toString)).forEach(block -> {
                try {
                    BlockDump.appendBlock((Block)BuiltInRegistries.f_256975_.m_7745_(block), blocks);
                    blocks.append('\n');
                    for (BlockState state : ((Block)BuiltInRegistries.f_256975_.m_7745_(block)).m_49965_().m_61056_()) {
                        BlockDump.appendState(state, states);
                        states.append('\n');
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Writer newWriter(String name) throws IOException {
        return new BufferedWriter(new FileWriter(name));
    }

    private static void appendBlock(Block block, Writer writer) throws IOException {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)block) != null) {
            writer.append(BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        }
    }

    private static void appendState(BlockState state, Writer writer) throws IOException {
        BlockDump.appendBlock(state.m_60734_(), writer);
        if (!state.m_61147_().isEmpty()) {
            writer.append('[');
            boolean first = true;
            for (Map.Entry e : state.m_61148_().entrySet()) {
                if (!first) {
                    writer.append(',');
                }
                first = false;
                writer.append(((Property)e.getKey()).m_61708_()).append('=').append(e.getValue().toString());
            }
            writer.append(']');
        }
    }
}

