/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.init;

import com.conquestrefabricated.api.painting.PaintingHolder;
import com.conquestrefabricated.api.painting.art.Art;
import com.conquestreforged.content.entities.painting.ModPainting;
import com.conquestreforged.content.entities.painting.art.ArtType;
import com.conquestreforged.content.entities.painting.art.ModArt;
import com.conquestreforged.core.block.data.BlockData;
import com.conquestreforged.core.block.data.BlockDataRegistry;
import com.conquestreforged.core.block.data.ColorType;
import com.conquestreforged.core.item.family.FamilyGroup;
import com.conquestreforged.core.util.log.Log;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InitClient {
    @SubscribeEvent
    public static void blockColors(RegisterColorHandlersEvent.Block event) {
        Log.debug("Registering block colors", new Object[0]);
        for (BlockData data : BlockDataRegistry.getInstance()) {
            if (data.getProps().getColorType() == ColorType.GRASS) {
                event.register((state, view, pos, tintIndex) -> {
                    if (view == null || pos == null) {
                        return GrassColor.m_46415_((double)0.5, (double)1.0);
                    }
                    return BiomeColors.m_108793_((BlockAndTintGetter)view, (BlockPos)pos);
                }, new Block[]{data.getBlock()});
                continue;
            }
            if (data.getProps().getColorType() == ColorType.FOLIAGE) {
                event.register((state, view, pos, tintIndex) -> {
                    if (view == null || pos == null) {
                        return FoliageColor.m_46107_((double)0.5, (double)1.0);
                    }
                    return BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos);
                }, new Block[]{data.getBlock()});
                continue;
            }
            if (data.getProps().getColorType() != ColorType.WATER) continue;
            event.register((state, view, pos, tintIndex) -> BiomeColors.m_108811_((BlockAndTintGetter)view, (BlockPos)pos), new Block[]{data.getBlock()});
        }
    }

    @SubscribeEvent
    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        Log.debug("Registering item colors", new Object[0]);
        for (BlockData data : BlockDataRegistry.getInstance()) {
            if (data.getProps().getColorType() != ColorType.GRASS && data.getProps().getColorType() != ColorType.FOLIAGE) continue;
            event.register((stack, tintIndex) -> 7117131, new ItemLike[]{data.getItem()});
        }
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        Log.debug("Registering block render layers", new Object[0]);
        BlockDataRegistry.getInstance().forEach(BlockData::addRenders);
    }

    @SubscribeEvent
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        FamilyGroup.FAMILY_GROUPS.forEach(familyGroup -> {
            if (familyGroup.cached.isEmpty()) {
                NonNullList list = NonNullList.m_122779_();
                familyGroup.populate((NonNullList<ItemStack>)list);
                familyGroup.sorter.apply(list);
                if (event.getTab().equals(CreativeModeTabs.m_258007_())) {
                    event.m_246601_((Collection)list);
                }
                familyGroup.sorter.sort(list);
                familyGroup.cached = new ArrayList(list);
            }
            if (event.getTabKey().equals(BuiltInRegistries.f_279662_.m_7854_((Object)familyGroup).get())) {
                for (ItemStack item : familyGroup.cached) {
                    if (item.m_41720_() == Items.f_41852_) continue;
                    if (item.m_41720_() instanceof PaintingHolder) {
                        Art<ArtType> art = ModArt.of(ArtType.A1x1_0);
                        ModPainting.getIds().distinct().sorted().forEach(name -> {
                            ModPainting type = ModPainting.fromName(name);
                            ItemStack stack = type.createStack(art);
                            event.m_246342_(stack);
                        });
                        continue;
                    }
                    if (item.m_41720_() instanceof TippedArrowItem) {
                        for (Potion potion : BuiltInRegistries.f_256980_) {
                            if (potion.m_43488_().isEmpty()) continue;
                            event.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item.m_41720_()), (Potion)potion));
                        }
                        continue;
                    }
                    event.m_246326_((ItemLike)item.m_41720_());
                }
            }
        });
    }
}

