/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item;

import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import com.conquestreforged.core.item.family.TypeFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemUtils {
    public static final String BLOCK_STATE_TAG = "BlockStateTag";

    public static ItemStack fromState(BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        CompoundTag data = stack.m_41698_(BLOCK_STATE_TAG);
        for (Map.Entry e : state.m_61148_().entrySet()) {
            data.m_128359_(((Property)e.getKey()).m_61708_(), e.getValue().toString());
        }
        return stack;
    }

    public static ItemStack fromStateNoFacing(BlockState state) {
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        CompoundTag data = stack.m_41698_(BLOCK_STATE_TAG);
        for (Map.Entry e : state.m_61148_().entrySet()) {
            if (Objects.equals(((Property)e.getKey()).m_61708_(), "facing")) continue;
            data.m_128359_(((Property)e.getKey()).m_61708_(), e.getValue().toString());
        }
        return stack;
    }

    public static ItemStack fromState(BlockState state, Property<?> property) {
        String value = state.m_61143_(property).toString();
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        stack.m_41698_(BLOCK_STATE_TAG).m_128359_(property.m_61708_(), value);
        stack.m_41714_(Component.m_130674_((String)(stack.m_41611_().getString() + property.m_61708_() + "=" + value)));
        return stack;
    }

    public static ItemStack fromState(BlockState state, Collection<Property<?>> properties) {
        StringBuilder name = new StringBuilder("[");
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
        CompoundTag stateTag = stack.m_41698_(BLOCK_STATE_TAG);
        for (Property<?> property : properties) {
            if (!state.m_61138_(property)) continue;
            String value = state.m_61143_(property).toString();
            stateTag.m_128359_(property.m_61708_(), value);
            if (name.length() > 1) {
                name.append(',');
            }
            name.append(property.m_61708_()).append('=').append(value);
        }
        if (name.length() > 1) {
            name.append("]");
            stack.m_41714_(Component.m_130674_((String)(stack.m_41611_().getString() + name.toString())));
        }
        return stack;
    }

    public static <T extends Item> Optional<T> toItem(Item item, Class<T> t) {
        return t.isInstance(item) ? Optional.of((Item)t.cast(item)) : Optional.empty();
    }

    public static NonNullList<ItemStack> getFamilyItems(ItemStack stack) {
        return ItemUtils.getFamilyItems(stack, TypeFilter.ANY);
    }

    public static NonNullList<ItemStack> getFamilyItems(ItemStack stack, TypeFilter filter) {
        NonNullList items = NonNullList.m_122779_();
        ItemUtils.getFamily(stack).addAllItems(CreativeModeTabs.m_258007_(), (NonNullList<ItemStack>)items, filter);
        if (items.isEmpty()) {
            items.add((Object)stack);
        }
        return items;
    }

    public static Family<Block> getFamily(ItemStack stack) {
        Item item = stack.m_41720_();
        Block block = Blocks.f_50016_;
        if (item instanceof BlockItem) {
            block = ((BlockItem)item).m_40614_();
        }
        return FamilyRegistry.BLOCKS.getFamily(block);
    }
}

