/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.family;

import com.conquestreforged.core.item.family.Family;
import com.conquestreforged.core.item.family.FamilyRegistry;
import com.conquestreforged.core.item.group.ConquestItemGroup;
import com.conquestreforged.core.item.group.TaggedGroup;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class FamilyGroup
extends TaggedGroup<FamilyGroup> {
    public static final List<FamilyGroup> FAMILY_GROUPS = new LinkedList<FamilyGroup>();
    private static final Family.Filler ALL_ITEMS = Family::addAllItems;
    private static final Family.Filler ROOT_ITEMS = Family::addRootItem;
    private static Family.Filler filler = Family::addAllItems;
    public String label;
    private final Supplier<ItemStack> icon;

    public FamilyGroup(int order, String label, Supplier<ItemStack> icon, CreativeModeTab.Row row, int column, CreativeModeTab.Type type, Component text, CreativeModeTab.DisplayItemsGenerator entryCollector) {
        super(order, label, row, column, type, text, icon, entryCollector);
        this.label = label;
        this.icon = icon;
        FAMILY_GROUPS.add(this);
    }

    @Override
    public FamilyGroup self() {
        return this;
    }

    @Override
    public void populate(NonNullList<ItemStack> items) {
        FamilyRegistry.BLOCKS.values().forEach(family -> filler.fill((Family)family, this, items));
        FamilyRegistry.ITEMS.values().forEach(family -> filler.fill((Family)family, this, items));
    }

    public static void setAddAllItems() {
        if (filler != ALL_ITEMS) {
            filler = ALL_ITEMS;
            FAMILY_GROUPS.forEach(ConquestItemGroup::invalidate);
        }
    }

    public static void setAddRootItems() {
        if (filler != ROOT_ITEMS) {
            filler = ROOT_ITEMS;
            FAMILY_GROUPS.forEach(ConquestItemGroup::invalidate);
        }
    }

    public static Stream<FamilyGroup> stream() {
        return FAMILY_GROUPS.stream().sorted(Comparator.comparing(ConquestItemGroup::getOrderIndex));
    }
}

