/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.item.group;

import com.conquestreforged.core.asset.lang.Translations;
import com.conquestreforged.core.init.Context;
import com.conquestreforged.core.item.family.FamilyGroup;
import com.conquestreforged.core.item.group.sort.ItemList;
import com.conquestreforged.core.item.group.sort.Sorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public abstract class ConquestItemGroup
extends CreativeModeTab {
    private static final String pathFormat = "/assets/%s/groups/%s.txt";
    private final int index;
    private final Component translationKey;
    public final Sorter<ItemStack> sorter;
    public List<ItemStack> cached = Collections.emptyList();

    public ConquestItemGroup(int index, String label, CreativeModeTab.Row row, int i, CreativeModeTab.Type type, Component text, Supplier<ItemStack> supplier, CreativeModeTab.DisplayItemsGenerator entryCollector) {
        super(CreativeModeTab.builder().m_257609_("items.png").m_257737_(supplier).withBackgroundLocation(new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png")).m_257941_(text));
        String namespace = Context.getInstance().getNamespace();
        this.index = index;
        this.translationKey = Component.m_237115_((String)Translations.getKey("itemGroup", namespace, label));
        this.sorter = this.getItemSorter(namespace, label);
        Translations.getInstance().add(this.translationKey.getString(), Translations.translate(label));
    }

    public Component m_40786_() {
        return this.translationKey;
    }

    public void invalidate() {
        this.cached = Collections.emptyList();
    }

    public int getOrderIndex() {
        return this.index;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Sorter<ItemStack> getItemSorter(String namespace, String label) {
        String path = String.format(pathFormat, namespace, label);
        try (InputStream in = FamilyGroup.class.getResourceAsStream(path);){
            ItemList itemList;
            if (in == null) {
                Sorter<ItemStack> sorter = Sorter.none();
                return sorter;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                itemList = ItemList.read(reader);
            }
            return itemList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Sorter.none();
        }
    }

    public abstract void populate(NonNullList<ItemStack> var1);
}

