/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.core.util;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class Provider<T extends ItemLike>
implements ItemLike {
    private final String name;
    private final Supplier<T> supplier;
    private final Supplier<T> defaultValue;
    private T value;

    private Provider(String name, Supplier<T> supplier, Supplier<T> defaultValue) {
        this.name = name;
        this.supplier = supplier;
        this.defaultValue = defaultValue;
    }

    public T get() {
        if (this.value == null) {
            this.value = (ItemLike)this.supplier.get();
            if (this.value == null) {
                new NullPointerException("Invalid item: " + this.name).printStackTrace();
                this.value = (ItemLike)this.defaultValue.get();
            }
        }
        return this.value;
    }

    public Stack toStack() {
        return new Stack(this);
    }

    public net.minecraft.world.item.Item m_5456_() {
        T t = this.get();
        if (t == null) {
            throw new NullPointerException("Invalid item: " + this.name);
        }
        return t.m_5456_();
    }

    public static Block block(String name) {
        return Provider.block(new ResourceLocation(name));
    }

    public static Block block(ResourceLocation name) {
        return Provider.block(String.valueOf(name), () -> (net.minecraft.world.level.block.Block)BuiltInRegistries.f_256975_.m_7745_(name));
    }

    public static Block block(String name, Supplier<net.minecraft.world.level.block.Block> getter) {
        return new Block(name, getter);
    }

    public static Item item(String name) {
        return Provider.item(new ResourceLocation(name));
    }

    public static Item item(ResourceLocation name) {
        return Provider.item(String.valueOf(name), () -> (net.minecraft.world.item.Item)BuiltInRegistries.f_257033_.m_7745_(name));
    }

    public static Item item(String name, Supplier<net.minecraft.world.item.Item> getter) {
        return new Item(name, getter);
    }

    public static class Stack
    implements Supplier<ItemStack> {
        private final ItemLike provider;

        public Stack(ItemLike provider) {
            this.provider = provider;
        }

        @Override
        public ItemStack get() {
            return new ItemStack((ItemLike)this.provider.m_5456_());
        }

        public Optional<ItemStack> getSafely() {
            net.minecraft.world.item.Item item = this.provider.m_5456_();
            if (item == Items.f_41852_) {
                return Optional.empty();
            }
            return Optional.of(new ItemStack((ItemLike)item));
        }
    }

    public static class Block
    extends Provider<net.minecraft.world.level.block.Block> {
        public Block(String name, Supplier<net.minecraft.world.level.block.Block> supplier) {
            super(name, supplier, () -> Blocks.f_50016_);
        }
    }

    public static class Item
    extends Provider<net.minecraft.world.item.Item> {
        public Item(String name, Supplier<net.minecraft.world.item.Item> supplier) {
            super(name, supplier, () -> Items.f_41852_);
        }
    }
}

