/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui;

import com.conquestrefabricated.client.gui.render.Render;
import com.conquestrefabricated.client.utils.CreativeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public abstract class PickerScreen<T>
extends class_437 {
    private final class_1799 stack;
    private final T selected;
    private final List<T> options;
    private int index = -1;

    public PickerScreen(String title, class_1799 stack, T selected, List<T> options) {
        super((class_2561)class_2561.method_43470((String)title));
        this.stack = stack;
        this.options = options;
        this.selected = selected;
    }

    public boolean match(T a, T b) {
        return a.equals(b);
    }

    public void method_25426() {
        super.method_25426();
        this.index = this.indexOf(this.selected, this.options);
        Render.hideMouse();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        class_310.method_1551().method_1507(null);
        return super.method_25402(mouseX, mouseY, mouseButton);
    }

    public boolean method_25404(int typedChar, int keyCode, int what) {
        if (typedChar == 263 && --this.index < 0) {
            this.index = this.options.size() - 1;
        }
        if (typedChar == 262 && ++this.index >= this.options.size()) {
            this.index = 0;
        }
        return super.method_25404(typedChar, keyCode, what);
    }

    public void method_25394(class_332 matrixStack, int mouseX, int mouseY, float partialTicks) {
        int size;
        this.method_25434(matrixStack);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int maxWidth = this.options.size() / 2;
        int visited = 0;
        for (int i = size = Math.min(maxWidth, this.getSize()); i >= 0; --i) {
            if (i == 0) {
                this.renderOption(matrixStack, centerX, centerY, i);
                continue;
            }
            this.renderOption(matrixStack, centerX, centerY, i);
            if (++visited >= this.options.size() - 1) continue;
            this.renderOption(matrixStack, centerX, centerY, -i);
        }
        this.drawLabel(matrixStack, centerX, centerY);
    }

    public boolean method_25401(double mx, double my, double scroll) {
        if (scroll > 0.0 && --this.index < 0) {
            this.index = this.options.size() - 1;
        }
        if (scroll < 0.0 && ++this.index >= this.options.size()) {
            this.index = 0;
        }
        return false;
    }

    public void method_25432() {
        Render.showMouse();
        if (this.field_22787 == null || this.field_22787.field_1724 == null || !this.field_22787.field_1724.method_7337()) {
            return;
        }
        T option = this.options.get(this.index);
        CreativeUtils.replaceItemStack(this.stack, this.createItemStack(this.stack, option));
    }

    private void renderOption(class_332 matrixStack, int cx, int cy, int di) {
        int height;
        int index = this.index + di;
        if (index < 0) {
            index += this.options.size();
        }
        if (index >= this.options.size()) {
            index -= this.options.size();
        }
        if (index < 0 || index >= this.options.size()) {
            return;
        }
        float scale = 2.0f - (float)Math.abs(di) / 4.0f;
        float count = this.getSize() * 2 + 1;
        int size = Math.round((float)this.field_22789 / count * scale);
        int left = cx + 1 + di * (size + 1) - size / 2;
        int top = cy - size / 2;
        T option = this.options.get(index);
        float w = 1.0f;
        float h = 1.0f;
        int width = this.getWidth(option);
        if (width != (height = this.getHeight(option))) {
            float scale1 = 1.0f / (float)Math.max(width, height);
            w = (float)width * scale1;
            h = (float)height * scale1;
        }
        int tw = Math.round((float)size * w);
        int th = Math.round((float)size * h);
        int tl = left + (size - tw) / 2;
        int tt = top + (size - th) / 2;
        float alpha = Math.min(1.0f, 0.4f + Math.max(0.0f, 1.0f - (float)Math.abs(di) / 2.0f));
        RenderSystem.setShaderColor((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        matrixStack.method_51448().method_22903();
        matrixStack.method_51448().method_46416(0.0f, 0.0f, scale * 50.0f);
        this.render(option, matrixStack, tl, tt, tw, th, scale);
        matrixStack.method_51448().method_22909();
    }

    private void drawLabel(class_332 matrixStack, int centerX, int centerY) {
        if (this.index < 0 || this.index >= this.options.size()) {
            return;
        }
        int height = this.field_22789 / (this.getSize() * 2 + 1) + 10;
        int barWidth = 150;
        int barLeft = this.field_22789 / 2 - barWidth / 2;
        int barTop = centerY + height + this.getYOffset();
        int barRight = barLeft + barWidth;
        int barBottom = barTop + 3;
        float position = (float)this.index / (float)(this.options.size() - 1);
        int posLeft = barLeft + Math.round(position * (float)barWidth) - 1;
        int posRight = posLeft + 2;
        matrixStack.method_25296(barLeft, barTop, barRight, barBottom, 0x44000000, 0x44000000);
        matrixStack.method_25296(posLeft, barTop, posRight, barBottom, 0x66FFFFFF, 0x66FFFFFF);
        T option = this.options.get(this.index);
        String text = this.getDisplayName(option);
        int width = this.field_22793.method_1727(text);
        float top = barTop + 15;
        float left = (float)centerX - (float)width / 2.0f;
        matrixStack.method_25303(this.field_22793, text, (int)left, (int)top, 0xFFFFFF);
    }

    private int indexOf(T value, List<T> options) {
        for (int i = 0; i < options.size(); ++i) {
            if (!this.match(value, options.get(i))) continue;
            return i;
        }
        return 0;
    }

    public int getSize() {
        return 5;
    }

    public int getYOffset() {
        return 0;
    }

    public abstract int getWidth(T var1);

    public abstract int getHeight(T var1);

    public abstract String getDisplayName(T var1);

    public abstract void render(T var1, class_332 var2, int var3, int var4, int var5, int var6, float var7);

    public abstract class_1799 createItemStack(class_1799 var1, T var2);
}

