/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.dependency;

import com.conquestrefabricated.client.gui.dependency.Dependency;
import com.conquestrefabricated.client.gui.dependency.PackIdDeserializer;
import java.io.IOException;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3288;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DependencyType {
    UNKNOWN{

        @Override
        public boolean isAvailable(Dependency dependency) {
            return true;
        }
    }
    ,
    MOD{

        @Override
        public boolean isAvailable(Dependency dependency) {
            return FabricLoader.getInstance().isModLoaded(dependency.getId());
        }
    }
    ,
    LIB{

        @Override
        public boolean isAvailable(Dependency dependency) {
            try {
                Class.forName(dependency.getId());
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }
    ,
    RESOURCEPACK{

        @Override
        public boolean isAvailable(Dependency dependency) {
            for (class_3288 pack : class_310.method_1551().method_1520().method_14444()) {
                try {
                    Object packId = pack.method_14458().method_14407((class_3270)PackIdDeserializer.INSTANCE);
                    if (!dependency.getId().equalsIgnoreCase(String.valueOf(packId))) continue;
                    return true;
                }
                catch (IOException iOException) {
                }
            }
            return false;
        }
    };


    public abstract boolean isAvailable(Dependency var1);

    static DependencyType of(String name) {
        for (DependencyType type : DependencyType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return UNKNOWN;
    }
}

