/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.palette.shape;

import com.conquestrefabricated.client.gui.palette.shape.FloatMath;
import com.conquestrefabricated.client.gui.palette.shape.Point;

public class Edge {
    private final float angle;
    private final float partialAngle;
    private final float length;
    private final float outerLength;
    private final float innerLength;
    final Point start;
    final Point end;
    final Point outerStart;
    final Point outerEnd;
    final Point innerStart;
    final Point innerEnd;

    public Edge(Point cStart, Point oStart, Point iStart, int centerX, int centerY, int radius, int outerPadding, int innerPadding, float angle, float angleIncrement) {
        float rads = (float)Math.toRadians(angle);
        this.start = cStart;
        this.end = Edge.toPoint(centerX, centerY, radius, rads);
        this.outerStart = oStart;
        this.outerEnd = Edge.toPoint(centerX, centerY, radius + outerPadding, rads);
        this.innerStart = iStart;
        this.innerEnd = Edge.toPoint(centerX, centerY, radius - innerPadding, rads);
        this.angle = angle;
        this.partialAngle = angleIncrement;
        this.length = this.start.distance(this.end);
        this.outerLength = this.outerStart.distance(this.outerEnd);
        this.innerLength = this.innerStart.distance(this.innerEnd);
    }

    public double getAngle() {
        return this.angle;
    }

    public Point getPosition(float angle) {
        return Edge.getPosition(this.start, this.end, this.length, angle, this.partialAngle);
    }

    public Point getOuterPosition(float angle) {
        return Edge.getPosition(this.outerStart, this.outerEnd, this.outerLength, angle, this.partialAngle);
    }

    public Point getInnerPosition(float angle) {
        return Edge.getPosition(this.innerStart, this.innerEnd, this.innerLength, angle, this.partialAngle);
    }

    private static Point getPosition(Point start, Point end, float length, float angle, float partialAngle) {
        float progress = angle % partialAngle / partialAngle;
        float dl = progress * length;
        float t = dl / length;
        int x = FloatMath.round((1.0f - t) * (float)start.x + t * (float)end.x);
        int y = FloatMath.round((1.0f - t) * (float)start.y + t * (float)end.y);
        return new Point(x, y);
    }

    static Point toPoint(int cX, int cY, int radius, float rads) {
        int x = (int)Math.round((double)cX + Math.cos(rads) * (double)radius);
        int y = (int)Math.round((double)cY + Math.sin(rads) * (double)radius);
        return new Point(x, y);
    }
}

