/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.palette.texture;

import com.conquestrefabricated.client.gui.palette.texture.ItemGroup;
import com.conquestrefabricated.client.gui.palette.texture.TextureGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5609;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class TextureGroupManager {
    private static final class_5819 random = class_5819.method_43047();
    private static final class_5609 nodata = new class_5609();
    private static final TextureGroupManager INSTANCE = new TextureGroupManager();
    private final Map<class_1792, ItemGroup> blockGroups = new HashMap<class_1792, ItemGroup>();
    private final Map<String, TextureGroup> textureGroups = new HashMap<String, TextureGroup>();

    public ItemGroup getGroup(class_2248 block) {
        return this.getGroup(block.method_8389());
    }

    public ItemGroup getGroup(class_2680 state) {
        return this.getGroup(state.method_26204());
    }

    public ItemGroup getGroup(class_1799 stack) {
        return this.getGroup(stack.method_7909());
    }

    public ItemGroup getGroup(class_1792 item) {
        return this.blockGroups.getOrDefault(item, ItemGroup.NONE);
    }

    private void rebuild() {
        this.textureGroups.clear();
        this.blockGroups.clear();
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)item;
            this.addState(item, blockItem.method_7711().method_9564());
        }
    }

    private void addState(class_1792 item, class_2680 state) {
        Map<String, Integer> textures = TextureGroupManager.getTextures(state);
        int count = Integer.MAX_VALUE;
        TextureGroup main = null;
        LinkedList<TextureGroup> itemGroups = new LinkedList<TextureGroup>();
        for (Map.Entry<String, Integer> entry : textures.entrySet()) {
            TextureGroup textureGroup = this.textureGroups.computeIfAbsent(entry.getKey(), TextureGroup::new);
            textureGroup.add(item);
            itemGroups.add(textureGroup);
            if (entry.getValue() >= count) continue;
            main = textureGroup;
        }
        if (main != null) {
            this.blockGroups.put(item, new ItemGroup(main, itemGroups));
        }
    }

    private static Map<String, Integer> getTextures(class_2680 state) {
        class_1087 model = class_310.method_1551().method_1541().method_3351().method_3335(state);
        return TextureGroupManager.getTextures(state, model);
    }

    private static Map<String, Integer> getTextures(class_2680 state, @Nullable class_1087 model) {
        if (model == null || model == class_310.method_1551().method_1554().method_4744()) {
            return Collections.emptyMap();
        }
        List quads = model.method_4707(state, null, random);
        HashMap<String, Integer> textures = new HashMap<String, Integer>();
        TextureGroupManager.addTexture(model.method_4711(), textures);
        for (class_777 quad : quads) {
            TextureGroupManager.addTexture(quad.method_35788(), textures);
        }
        return textures;
    }

    private static void addTexture(@Nullable class_1058 sprite, Map<String, Integer> textures) {
        String texture = TextureGroupManager.getTextureName(sprite);
        if (!texture.isEmpty()) {
            int count = textures.getOrDefault(texture, 0);
            textures.put(texture, count + 1);
        }
    }

    private static String getTextureName(@Nullable class_1058 sprite) {
        if (sprite != null) {
            try {
                return TextureGroupManager.getResourceName(sprite.method_45852());
            }
            catch (Throwable t) {
                return "";
            }
        }
        return "";
    }

    private static String getResourceName(@Nullable class_2960 location) {
        if (location != null) {
            return location.toString();
        }
        return "";
    }

    public static TextureGroupManager getInstance() {
        return INSTANCE;
    }
}

