/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.search;

import com.conquestrefabricated.client.utils.CreativeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_746;

public class SearchList
implements class_364,
class_6379 {
    private static final int slotSize = 20;
    private static final int stackSize = 16;
    private static final int stackPad = 2;
    public float x;
    public float y;
    public float scale = 1.0f;
    private int count = 0;
    private int maxRow = 0;
    private final int rows;
    private final int columns;
    private final Slot[] slots;
    private Slot hovered = null;

    public SearchList(int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        this.slots = new Slot[columns * rows];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                int i = c + r * columns;
                this.slots[i] = new Slot(c, r);
            }
        }
    }

    public int getHeight() {
        if (this.count == 0) {
            return 0;
        }
        return Math.round((float)(this.rows * 20) * this.scale);
    }

    public int getWidth() {
        return Math.round((float)(this.columns * 20) * this.scale);
    }

    public int size() {
        return this.count;
    }

    public int maxSize() {
        return this.rows * this.columns;
    }

    public synchronized void add(class_1799 stack) {
        Slot slot = this.slots[this.count++];
        slot.stack = stack;
        this.maxRow = slot.row;
    }

    public synchronized void clear() {
        this.count = 0;
        this.maxRow = 0;
        for (Slot slot : this.slots) {
            slot.stack = class_1799.field_8037;
        }
    }

    public void render(class_332 drawContext, int mx, int my, int width, int height, float tick) {
        this.hovered = null;
        for (Slot slot : this.slots) {
            if (slot.col == 0 && slot.stack.method_7960() || !slot.fitsOnScreen(width, height)) break;
            slot.render(drawContext.method_51448(), mx, my);
        }
        if (this.hovered == null) {
            return;
        }
        String name = this.hovered.stack.method_7954().getString();
        int nameWidth = class_310.method_1551().field_1772.method_1727(name);
        int left = width / 2 - nameWidth / 2;
        drawContext.method_51433(class_310.method_1551().field_1772, name, left, height - 32, 0xFFFFFF, true);
    }

    public boolean method_25402(double mx, double my, int button) {
        for (Slot slot : this.slots) {
            if (!slot.click(mx, my)) continue;
            return true;
        }
        return false;
    }

    public void method_25365(boolean bl) {
    }

    public boolean method_25370() {
        return false;
    }

    public void method_37020(class_6382 p_169152_) {
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public boolean method_37303() {
        return super.method_37303();
    }

    private class Slot
    extends class_332 {
        private final int col;
        private final int row;
        private class_1799 stack;

        private Slot(int col, int row) {
            super(class_310.method_1551(), class_4597.method_22991((class_287)new class_287(256)));
            this.stack = class_1799.field_8037;
            this.row = row;
            this.col = col;
        }

        private float left() {
            return SearchList.this.x + (float)(this.col * 20) * SearchList.this.scale;
        }

        private float top() {
            return SearchList.this.y + (float)(this.row * 20) * SearchList.this.scale;
        }

        private boolean mouseOver(double mx, double my) {
            float l = this.left();
            float t = this.top();
            float size = 20.0f * SearchList.this.scale;
            return mx >= (double)l && mx <= (double)(l + size) && my >= (double)t && my <= (double)(t + size);
        }

        private boolean fitsOnScreen(int width, int height) {
            float right = this.left() + 20.0f * SearchList.this.scale;
            float bottom = this.top() + 20.0f * SearchList.this.scale;
            return right < (float)width && bottom < (float)(height - 32);
        }

        private void render(class_4587 matrixStack, double mx, double my) {
            float top = this.top();
            float left = this.left();
            class_4587 posestack = RenderSystem.getModelViewStack();
            posestack.method_22903();
            posestack.method_46416(left, top, 0.0f);
            posestack.method_22905(SearchList.this.scale, SearchList.this.scale, SearchList.this.scale);
            RenderSystem.applyModelViewMatrix();
            if (!this.stack.method_7960()) {
                this.method_51427(this.stack, 2, 2);
            }
            posestack.method_22909();
            RenderSystem.applyModelViewMatrix();
            matrixStack.method_22903();
            matrixStack.method_46416(left, top, 0.0f);
            matrixStack.method_22905(SearchList.this.scale, SearchList.this.scale, SearchList.this.scale);
            this.method_25294(0, 0, 20, 20, 0x55000000);
            if (this.mouseOver(mx, my)) {
                SearchList.this.hovered = this;
                this.method_25294(1, 1, 19, 19, 0x55999999);
            }
            matrixStack.method_22909();
            RenderSystem.enableDepthTest();
        }

        private boolean click(double mx, double my) {
            if (this.mouseOver(mx, my)) {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return false;
                }
                if (CreativeUtils.addItemStack(this.stack.method_7972(), true)) {
                    class_310.method_1551().method_1507(null);
                    return true;
                }
            }
            return false;
        }
    }
}

