/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.search;

import com.conquestrefabricated.client.gui.search.SearchList;
import com.conquestrefabricated.client.gui.search.query.Index;
import com.conquestrefabricated.client.gui.search.query.Result;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3528;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6862;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class SearchScreen
extends class_437
implements Consumer<String> {
    private static final float scale = 2.0f;
    private static final class_3528<Index<class_1799>> index = new class_3528(SearchScreen::buildIndex);
    private final class_342 search;
    private final Index<class_1799> itemIndex;
    private final SearchList searchList;

    public SearchScreen() {
        super((class_2561)class_2561.method_43470((String)"search"));
        this.search = new class_342(class_310.method_1551().field_1772, 0, 0, 200, 20, (class_2561)class_2561.method_43471((String)"Search"));
        this.search.method_1863((Consumer)this);
        this.itemIndex = (Index)index.method_15332();
        this.searchList = new SearchList(5, 6);
    }

    public boolean method_25402(double mx, double my, int button) {
        if (!super.method_25402(mx, my, button)) {
            class_310.method_1551().method_1507(null);
            return false;
        }
        return true;
    }

    public void method_25393() {
        super.method_25393();
        this.check();
    }

    protected void method_25426() {
        this.method_37063((class_364)this.search);
        int centerX = this.field_22789 / 2;
        this.search.method_46421(centerX - this.search.method_25368() / 2);
        this.search.method_46419(100);
        this.method_25429(this.searchList);
    }

    public void method_25394(class_332 drawContext, int mx, int my, float ticks) {
        this.update();
        super.method_25420(drawContext);
        super.method_25394(drawContext, mx, my, ticks);
        this.searchList.render(drawContext, mx, my, this.field_22789, this.field_22790, ticks);
    }

    @Override
    public void accept(String term) {
        this.searchList.clear();
        ((Stream)this.itemIndex.parallelSearch(term, this.searchList.maxSize()).sequential()).map(Result::getResult).forEach(this.searchList::add);
        if (this.searchList.size() == 0) {
            this.search.method_46419(this.field_22790 / 2 - this.search.method_25364() / 2);
        } else {
            this.search.method_46419(20);
        }
    }

    private void update() {
        int pad = 8;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int guiHeight = this.search.method_25364() + pad + this.searchList.getHeight();
        this.method_25395((class_364)this.search);
        this.search.method_25365(true);
        this.search.method_46421(centerX - this.search.method_25368() / 2);
        this.search.method_46419(Math.max(10, centerY - guiHeight / 2));
        this.searchList.x = (float)centerX - (float)this.searchList.getWidth() / 2.0f;
        this.searchList.y = this.search.method_46427() + this.search.method_25364() + pad;
        this.searchList.scale = 2.0f;
    }

    private void check() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || !player.method_31549().field_7477) {
            class_310.method_1551().method_1507(null);
        }
    }

    private static Index<class_1799> buildIndex() {
        Index.Builder<class_1799> builder = Index.builder();
        for (class_1792 item : class_7923.field_41178.method_10220().toList()) {
            if (item == class_1802.field_8162) continue;
            class_1799 stack = new class_1799((class_1935)item);
            builder.with(stack, stack.method_7954().getString(), SearchScreen.getTags(stack));
        }
        return builder.build();
    }

    private static Collection<String> getTags(class_1799 item) {
        LinkedList<String> tags = new LinkedList<String>();
        tags.add(class_7923.field_41178.method_10221((Object)item.method_7909()).method_12832());
        List itemTags = item.method_40133().collect(Collectors.toList());
        for (class_6862 tag : itemTags) {
            tags.add(tag.comp_327().method_12832());
        }
        return tags;
    }
}

