/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.models;

import com.conquestrefabricated.content.blocks.block.decor.Loom;
import com.conquestrefabricated.content.blocks.tileentity.TileEntityTypes;
import com.conquestrefabricated.content.blocks.tileentity.loom.LoomBlockEntity;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;

public class LoomBakedModel
extends ForwardingBakedModel {
    private final class_1087 extraModel;
    private final class_1058[] sprites;

    public LoomBakedModel(class_1087 baseModel, class_1087 extraModel, class_1058[] sprites) {
        this.wrapped = baseModel;
        this.sprites = sprites;
        this.extraModel = extraModel;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2586 blockEntity = blockView.method_8321(pos);
        class_1058 sprite = this.sprites[0];
        if (((Boolean)state.method_11654((class_2769)Loom.HAS_THREAD)).booleanValue()) {
            if (blockEntity != null && blockEntity.method_11017() == TileEntityTypes.LOOM) {
                String productData = ((LoomBlockEntity)blockEntity).getProduct();
                int textureVariantIndex = this.getTextureVariant(productData);
                sprite = this.sprites[textureVariantIndex];
            }
            class_1058 originalSprite = this.sprites[this.getTextureVariant("conquest:white_canvas")];
            class_1058 finalSprite = sprite;
            context.pushTransform(quad -> {
                float u0 = quad.u(0);
                float u1 = quad.u(1);
                float u2 = quad.u(2);
                float u3 = quad.u(3);
                float v0 = quad.v(0);
                float v1 = quad.v(1);
                float v2 = quad.v(2);
                float v3 = quad.v(3);
                float spriteWidth = originalSprite.method_4577() - originalSprite.method_4594();
                float spriteHeight = originalSprite.method_4575() - originalSprite.method_4593();
                float nu0 = (u0 - originalSprite.method_4594()) / spriteWidth;
                float nu1 = (u1 - originalSprite.method_4594()) / spriteWidth;
                float nu2 = (u2 - originalSprite.method_4594()) / spriteWidth;
                float nu3 = (u3 - originalSprite.method_4594()) / spriteWidth;
                float nv0 = (v0 - originalSprite.method_4593()) / spriteHeight;
                float nv1 = (v1 - originalSprite.method_4593()) / spriteHeight;
                float nv2 = (v2 - originalSprite.method_4593()) / spriteHeight;
                float nv3 = (v3 - originalSprite.method_4593()) / spriteHeight;
                quad.spriteBake(finalSprite, 0);
                float newU0 = finalSprite.method_4594() + nu0 * (finalSprite.method_4577() - finalSprite.method_4594());
                float newU1 = finalSprite.method_4594() + nu1 * (finalSprite.method_4577() - finalSprite.method_4594());
                float newU2 = finalSprite.method_4594() + nu2 * (finalSprite.method_4577() - finalSprite.method_4594());
                float newU3 = finalSprite.method_4594() + nu3 * (finalSprite.method_4577() - finalSprite.method_4594());
                float newV0 = finalSprite.method_4593() + nv0 * (finalSprite.method_4575() - finalSprite.method_4593());
                float newV1 = finalSprite.method_4593() + nv1 * (finalSprite.method_4575() - finalSprite.method_4593());
                float newV2 = finalSprite.method_4593() + nv2 * (finalSprite.method_4575() - finalSprite.method_4593());
                float newV3 = finalSprite.method_4593() + nv3 * (finalSprite.method_4575() - finalSprite.method_4593());
                quad.uv(0, newU0, newV0);
                quad.uv(1, newU1, newV1);
                quad.uv(2, newU2, newV2);
                quad.uv(3, newU3, newV3);
                return true;
            });
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            context.popTransform();
        }
        context.pushTransform(quad -> true);
        this.extraModel.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private int getTextureVariant(String productData) {
        return switch (productData) {
            case "conquest:red_canvas" -> 1;
            case "conquest:black_canvas" -> 2;
            case "conquest:gray_canvas" -> 3;
            case "conquest:light_gray_canvas" -> 4;
            case "conquest:white_canvas" -> 5;
            case "conquest:brown_canvas" -> 6;
            case "conquest:yellow_canvas" -> 7;
            case "conquest:orange_canvas" -> 8;
            case "conquest:pink_canvas" -> 9;
            case "conquest:magenta_canvas" -> 10;
            case "conquest:purple_canvas" -> 11;
            case "conquest:blue_canvas" -> 12;
            case "conquest:light_blue_canvas" -> 13;
            case "conquest:cyan_canvas" -> 14;
            case "conquest:green_canvas" -> 15;
            case "conquest:lime_canvas" -> 16;
            case "conquest:baotuo_rug" -> 17;
            case "conquest:berber_rug" -> 18;
            case "conquest:black_persian_rug" -> 19;
            case "conquest:blue_nain_rug" -> 20;
            case "conquest:brown_oriental_carpet" -> 21;
            case "conquest:celtic_knot_rug" -> 22;
            case "conquest:kashmiri_carpet" -> 23;
            case "conquest:kazakh_rug" -> 24;
            case "conquest:kilim_rug" -> 25;
            case "conquest:nahavand_rug" -> 26;
            case "conquest:red_and_blue_sarouk_rug" -> 27;
            case "conquest:red_oriental_carpet" -> 28;
            case "conquest:red_pazyryk_rug" -> 29;
            case "conquest:shirishabad_rug" -> 30;
            case "conquest:william_morris_rug" -> 31;
            case "conquest:yellow_red_persian_rug" -> 32;
            default -> 0;
        };
    }
}

