/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class TextUtils {
    public static void wrapComplexTextToList(class_2561 text, class_327 textRenderer, int maxWidth, List<class_2561> resultList) {
        ArrayList segments = new ArrayList();
        text.method_27658((style, string) -> {
            segments.add(new StyledTextSegment(string, style));
            return Optional.empty();
        }, class_2583.field_24360);
        class_5250 currentLine = class_2561.method_43470((String)"");
        int currentLineWidth = 0;
        for (StyledTextSegment segment : segments) {
            String content = segment.text;
            class_2583 style2 = segment.style;
            List<String> words = TextUtils.splitIntoWords(content);
            for (String word : words) {
                int wordWidth = TextUtils.getWidth(word, textRenderer, style2);
                if (currentLineWidth + wordWidth > maxWidth) {
                    if (!currentLine.getString().isEmpty()) {
                        resultList.add((class_2561)currentLine);
                        currentLine = class_2561.method_43470((String)"");
                        currentLineWidth = 0;
                    }
                    if (wordWidth > maxWidth) {
                        TextUtils.splitLongWord(word, textRenderer, style2, maxWidth, resultList);
                        continue;
                    }
                    currentLine = currentLine.method_10852((class_2561)class_2561.method_43470((String)word).method_10862(style2));
                    currentLineWidth = wordWidth;
                    continue;
                }
                currentLine = currentLine.method_10852((class_2561)class_2561.method_43470((String)word).method_10862(style2));
                currentLineWidth += wordWidth;
            }
        }
        if (!currentLine.getString().isEmpty()) {
            resultList.add((class_2561)currentLine);
        }
    }

    private static List<String> splitIntoWords(String text) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder currentWord = new StringBuilder();
        boolean inWhitespace = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(c);
            if (isWhitespace != inWhitespace && currentWord.length() > 0) {
                words.add(currentWord.toString());
                currentWord = new StringBuilder();
            }
            currentWord.append(c);
            inWhitespace = isWhitespace;
        }
        if (currentWord.length() > 0) {
            words.add(currentWord.toString());
        }
        return words;
    }

    private static void splitLongWord(String word, class_327 textRenderer, class_2583 style, int maxWidth, List<class_2561> resultList) {
        int end;
        for (int start = 0; start < word.length(); start += end) {
            end = TextUtils.findFittingCharacters(word.substring(start), textRenderer, style, maxWidth);
            String part = word.substring(start, start + end);
            resultList.add((class_2561)class_2561.method_43470((String)part).method_10862(style));
        }
    }

    private static int findFittingCharacters(String text, class_327 textRenderer, class_2583 style, int maxWidth) {
        if (text.isEmpty()) {
            return 0;
        }
        int low = 0;
        int high = text.length();
        while (low < high) {
            int mid = (low + high + 1) / 2;
            int width = TextUtils.getWidth(text.substring(0, mid), textRenderer, style);
            if (width <= maxWidth) {
                low = mid;
                continue;
            }
            high = mid - 1;
        }
        return Math.max(1, low);
    }

    private static int getWidth(String text, class_327 textRenderer, class_2583 style) {
        return textRenderer.method_27525((class_5348)class_2561.method_43470((String)text).method_10862(style));
    }

    private static class StyledTextSegment {
        public final String text;
        public final class_2583 style;

        public StyledTextSegment(String text, class_2583 style) {
            this.text = text;
            this.style = style;
        }
    }
}

