/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.content.blocks.util;

import com.conquestrefabricated.content.blocks.block.BoardsHorizontal;
import com.conquestrefabricated.content.blocks.block.Layer;
import com.conquestrefabricated.content.blocks.block.Slab;
import com.conquestrefabricated.content.blocks.block.SlabLessLayers;
import com.conquestrefabricated.content.blocks.block.VerticalSlab;
import com.conquestrefabricated.core.block.properties.ModBlockProperties;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2480;
import net.minecraft.class_2482;
import net.minecraft.class_2488;
import net.minecraft.class_2573;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4057;

public class CauldronBehavior {
    public static final class_2746 OFFSET_TOGGLE = ModBlockProperties.OFFSET_TOGGLE;
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)3);
    private final List<class_265> hitBox;

    public CauldronBehavior(List<class_265> hitBox) {
        this.hitBox = hitBox;
    }

    public class_265 getCollisionShape(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (((Boolean)state.method_11654((class_2769)OFFSET_TOGGLE)).booleanValue()) {
            return class_259.method_1073();
        }
        return class_259.method_1077();
    }

    public class_265 getOutlineShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.hitBox.get(0);
    }

    public boolean calculateSlabOffset(class_2350 facing, class_2248 block, class_2680 state, class_1750 context) {
        if (facing == class_2350.field_11033) {
            return block instanceof Slab || block instanceof class_2482 || block instanceof Layer || block instanceof class_2488 || block instanceof SlabLessLayers || block instanceof BoardsHorizontal;
        }
        if (facing != class_2350.field_11036) {
            return block instanceof VerticalSlab && state.method_11654((class_2769)VerticalSlab.DIRECTION) == context.method_8038();
        }
        return false;
    }

    public void onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        int level = (Integer)state.method_11654((class_2769)LEVEL);
        float waterLevel = (float)pos.method_10264() + (6.0f + (float)(3 * level)) / 16.0f;
        if (!world.field_9236 && entity.method_5809() && level > 0 && entity.method_23318() <= (double)waterLevel) {
            entity.method_5646();
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level - 1)));
        }
    }

    public class_1269 onUse(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7960()) {
            return class_1269.field_5811;
        }
        int waterLevel = (Integer)state.method_11654((class_2769)LEVEL);
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8705) {
            return this.handleWaterBucket(state, level, blockPos, player, hand, waterLevel);
        }
        if (item == class_1802.field_8550) {
            return this.handleEmptyBucket(state, level, blockPos, player, hand, itemStack, waterLevel);
        }
        if (item == class_1802.field_8469) {
            return this.handleGlassBottle(state, level, blockPos, player, hand, itemStack, waterLevel);
        }
        if (item == class_1802.field_8574 && class_1844.method_8063((class_1799)itemStack) == class_1847.field_8991) {
            return this.handleWaterPotion(state, level, blockPos, player, hand, waterLevel);
        }
        return this.handleCleaningInteractions(state, level, blockPos, player, hand, itemStack, item, waterLevel);
    }

    private class_1269 handleWaterBucket(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, int waterLevel) {
        if (waterLevel < 3 && !level.field_9236) {
            if (!player.method_31549().field_7477) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
            }
            player.method_7281(class_3468.field_15430);
            level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3)));
            level.method_8396(null, blockPos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private class_1269 handleEmptyBucket(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_1799 itemStack, int waterLevel) {
        if (waterLevel == 3 && !level.field_9236) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
                if (itemStack.method_7960()) {
                    player.method_6122(hand, new class_1799((class_1935)class_1802.field_8705));
                } else if (!player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8705))) {
                    player.method_7328(new class_1799((class_1935)class_1802.field_8705), false);
                }
            }
            player.method_7281(class_3468.field_15373);
            level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
            level.method_8396(null, blockPos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private class_1269 handleGlassBottle(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_1799 itemStack, int waterLevel) {
        if (waterLevel > 0 && !level.field_9236) {
            if (!player.method_31549().field_7477) {
                class_1799 waterBottle = class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991);
                player.method_7281(class_3468.field_15373);
                itemStack.method_7934(1);
                if (itemStack.method_7960()) {
                    player.method_6122(hand, waterBottle);
                } else if (!player.method_31548().method_7394(waterBottle)) {
                    player.method_7328(waterBottle, false);
                } else if (player instanceof class_3222) {
                    ((class_3222)player).field_7498.method_34252();
                }
            }
            level.method_8396(null, blockPos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private class_1269 handleWaterPotion(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, int waterLevel) {
        if (waterLevel < 3 && !level.field_9236) {
            if (!player.method_31549().field_7477) {
                class_1799 glassBottle = new class_1799((class_1935)class_1802.field_8469);
                player.method_7281(class_3468.field_15373);
                player.method_6122(hand, glassBottle);
                if (player instanceof class_3222) {
                    ((class_3222)player).field_7498.method_34252();
                }
            }
            level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(waterLevel + 1)));
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    private class_1269 handleCleaningInteractions(class_2680 state, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_1799 itemStack, class_1792 item, int waterLevel) {
        class_4057 dyeableItem;
        if (waterLevel <= 0) {
            return class_1269.field_5811;
        }
        if (item instanceof class_4057 && (dyeableItem = (class_4057)item).method_7801(itemStack) && !level.field_9236) {
            dyeableItem.method_7798(itemStack);
            level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
            player.method_7281(class_3468.field_15382);
            return class_1269.field_5812;
        }
        if (item instanceof class_1746) {
            if (class_2573.method_10910((class_1799)itemStack) > 0 && !level.field_9236) {
                class_1799 cleanBanner = itemStack.method_7972();
                cleanBanner.method_7939(1);
                class_2573.method_10905((class_1799)cleanBanner);
                player.method_7281(class_3468.field_15390);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                    level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
                }
                if (itemStack.method_7960()) {
                    player.method_6122(hand, cleanBanner);
                } else if (!player.method_31548().method_7394(cleanBanner)) {
                    player.method_7328(cleanBanner, false);
                } else if (player instanceof class_3222) {
                    ((class_3222)player).field_7498.method_34252();
                }
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            if (block instanceof class_2480 && !level.method_8608()) {
                class_1799 cleanShulkerBox = new class_1799((class_1935)class_2246.field_10603, 1);
                if (itemStack.method_7985()) {
                    cleanShulkerBox.method_7980(itemStack.method_7969().method_10553());
                }
                player.method_6122(hand, cleanShulkerBox);
                level.method_8501(blockPos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(waterLevel - 1)));
                player.method_7281(class_3468.field_15398);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void precipitationTick(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2680 currentState;
        float temperature;
        if (world.field_9229.method_43048(20) == 1 && (temperature = ((class_1959)world.method_23753(pos).comp_349()).method_8712()) >= 0.15f && (Integer)(currentState = world.method_8320(pos)).method_11654((class_2769)LEVEL) < 3) {
            world.method_8652(pos, (class_2680)currentState.method_28493((class_2769)LEVEL), 2);
        }
    }

    public boolean hasComparatorOutput(class_2680 state) {
        return true;
    }

    public int getComparatorOutput(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }
}

