/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.asset.pack;

import com.conquestrefabricated.core.asset.VirtualResource;
import com.conquestrefabricated.core.asset.meta.VirtualMeta;
import com.conquestrefabricated.core.asset.pack.PackFinder;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public class VirtualResourcepack
extends class_3255
implements Supplier<class_3262> {
    private final class_3300 resourceManager;
    private final Map<String, VirtualResource> resources;

    private VirtualResourcepack(class_3264 type, class_3300 resourceManager, String name, Map<String, VirtualResource> resources) {
        super(name, true);
        this.resources = resources;
        this.resourceManager = resourceManager;
        PackFinder.getInstance(type).register(this);
    }

    public int size() {
        return this.resources.size();
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public class_3300 getResourceManager() {
        return this.resourceManager;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 resourceType, class_2960 identifier) {
        return null;
    }

    public void method_14408(class_3264 resourceType, String string, String string2, class_3262.class_7664 resultConsumer) {
    }

    public Set<String> method_14406(class_3264 type) {
        return this.resources.values().stream().filter(r -> r.getType() == type).map(VirtualResource::getNamespace).collect(Collectors.toSet());
    }

    public void close() {
    }

    public void forEach(BiConsumer<String, VirtualResource> visitor) {
        this.resources.forEach(visitor);
    }

    public List<Future<?>> export(Path dir, Gson gson) {
        ArrayList tasks = new ArrayList(this.resources.size());
        for (Map.Entry<String, VirtualResource> entry : this.resources.entrySet()) {
            Path path = dir.resolve(entry.getKey());
            VirtualResource resource = entry.getValue();
            tasks.add(ForkJoinPool.commonPool().submit(() -> {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        gson.toJson(resource.getJson(this.resourceManager), (Appendable)writer);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }));
        }
        return tasks;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    public class_3262 get() {
        return null;
    }

    public static class Builder {
        private final String namespace;
        private final List<VirtualResource> resources = new LinkedList<VirtualResource>();
        private class_3264 type = class_3264.field_14188;

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        public Builder type(class_3264 type) {
            this.type = type;
            return this;
        }

        public Builder add(VirtualResource resource) {
            this.resources.add(resource);
            return this;
        }

        public VirtualResourcepack build(class_3300 resourceManager) {
            HashMap<String, VirtualResource> map = new HashMap<String, VirtualResource>();
            map.put("pack.mcmeta", new VirtualMeta(this.namespace, this.namespace));
            this.resources.forEach(r -> map.put(r.getPath(), (VirtualResource)r));
            String suffix = this.type == class_3264.field_14188 ? "_resources" : "_data";
            return new VirtualResourcepack(this.type, resourceManager, this.namespace + suffix, map);
        }
    }
}

