/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block;

import com.conquestrefabricated.core.block.factory.InitializationException;
import com.conquestrefabricated.core.item.ItemUtils;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StateUtils {
    public static Optional<class_2680> getOrDefault(class_1799 stack) {
        return StateUtils.toItemBlock(stack.method_7909()).map(item -> StateUtils.fromStack(stack, item).orElse(item.method_7711().method_9564()));
    }

    public static Optional<class_2680> fromStack(class_1799 stack) {
        return StateUtils.toItemBlock(stack.method_7909()).flatMap(item -> StateUtils.fromStack(stack, item));
    }

    public static Optional<class_2680> fromStack(class_1799 stack, class_1747 item) {
        class_2487 stackTag = stack.method_7969();
        if (stackTag == null) {
            return Optional.of(item.method_7711().method_9564());
        }
        class_2487 stateTag = stackTag.method_10562("BlockStateTag");
        if (stateTag.method_33133()) {
            return Optional.of(item.method_7711().method_9564());
        }
        class_2680 state = item.method_7711().method_9564();
        class_2689 container = item.method_7711().method_9595();
        for (String key : stateTag.method_10541()) {
            class_2769 property = container.method_11663(key);
            if (property == null) continue;
            String s1 = stateTag.method_10580(key).method_10714();
            state = StateUtils.with(state, property, s1);
        }
        if (state == item.method_7711().method_9564()) {
            return Optional.empty();
        }
        return Optional.of(state);
    }

    public static Optional<class_1747> toItemBlock(class_1792 item) {
        return ItemUtils.toItem(item, class_1747.class);
    }

    public static class_2680 parse(String input) {
        int valStart;
        int valEnd;
        int keyStart;
        int keyEnd;
        int nameEnd;
        String name;
        int domainEnd = input.indexOf(58);
        String domain = domainEnd == -1 ? "minecraft" : input.substring(0, domainEnd);
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(domain, name = (nameEnd = input.indexOf(91)) == -1 ? input.substring(domainEnd + 1) : input.substring(domainEnd + 1, nameEnd)));
        if (block == null) {
            throw new InitializationException("invalid block " + input);
        }
        class_2680 state = block.method_9564();
        for (int i = nameEnd + 1; i < input.length() && (keyEnd = StateUtils.indexOf(input, keyStart = i, '=')) != -1 && (valEnd = StateUtils.indexOf(input, valStart = keyEnd + 1, ',', ']')) != -1; ++i) {
            String key = input.substring(keyStart, keyEnd);
            String value = input.substring(valStart, valEnd);
            state = StateUtils.with(state, key, value);
            i = valEnd + 1;
        }
        return state;
    }

    private static int indexOf(String string, int from, char ... chars) {
        for (char c : chars) {
            int i = string.indexOf(c, from);
            if (i == -1) continue;
            return i;
        }
        return -1;
    }

    private static class_2680 with(class_2680 state, String key, String value) {
        class_2769 property = state.method_26204().method_9595().method_11663(key);
        if (property == null) {
            return state;
        }
        return StateUtils.with(state, property, value);
    }

    public static <T extends Comparable<T>> class_2680 with(class_2680 state, class_2769<T> property, String value) {
        return property.method_11900(value).map(t -> (class_2680)state.method_11657(property, t)).orElse(state);
    }
}

