/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.block.builder;

import com.conquestrefabricated.core.block.builder.BlockName;
import com.conquestrefabricated.core.block.builder.BlockProps;
import com.conquestrefabricated.core.block.builder.Textures;
import com.conquestrefabricated.core.block.data.BlockTemplate;
import com.conquestrefabricated.core.block.data.ColorType;
import com.conquestrefabricated.core.block.factory.BlockFactory;
import com.conquestrefabricated.core.block.factory.InitializationException;
import com.conquestrefabricated.core.block.factory.TypeList;
import com.conquestrefabricated.core.init.Context;
import com.conquestrefabricated.core.item.family.DeferredFamilyRegistry;
import com.conquestrefabricated.core.item.family.Family;
import com.conquestrefabricated.core.item.family.FamilyFactory;
import com.conquestrefabricated.core.item.family.block.BlockFamily;
import com.conquestrefabricated.core.item.family.block.VariantFamily;
import com.conquestrefabricated.core.util.RenderLayer;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_7923;
import net.minecraft.class_8177;

public class Props
extends BlockProps<Props>
implements BlockFactory {
    private class_2680 parent = null;
    private BlockName name = null;
    private ColorType colorType = ColorType.NONE;
    private RenderLayer renderLayer = RenderLayer.UNDEFINED;
    private Textures.Builder textures;
    private Map<String, Object> extradata = Collections.emptyMap();
    private FamilyFactory<class_2248> familyFactory = FamilyFactory.of(BlockFamily::new);
    private class_2960 family = null;
    private class_8177 blockSetType = class_8177.field_42823;
    private class_4719 woodType = class_4719.field_21676;
    private boolean manual = false;

    private Props(class_2248 block) {
        super(block);
    }

    private Props(Props props) {
        super(props);
        this.name = props.name;
        this.manual = props.manual;
        this.parent = props.parent;
        this.textures = props.textures;
        this.colorType = props.colorType;
        this.extradata = props.extradata;
        this.renderLayer = props.renderLayer;
        this.familyFactory = props.familyFactory;
        this.family = props.family;
    }

    @Override
    public Props getProps() {
        return this;
    }

    @Override
    protected <T> void applyNonNull(Integer light, Consumer<T> lightLevel) {
    }

    @Override
    public BlockName getName() {
        if (this.name == null) {
            throw new InitializationException("Block name is null");
        }
        return this.name;
    }

    @Override
    public class_2680 getParent() throws InitializationException {
        if (this.parent == null) {
            throw new InitializationException("Parent state is null");
        }
        return this.parent;
    }

    @Override
    public Family<class_2248> createFamily(TypeList types) {
        class_2960 name = this.family == null ? (this.parent == null ? null : class_7923.field_41175.method_10221((Object)this.parent.method_26204())) : this.family;
        return this.familyFactory.create(name, this.group(), types);
    }

    public Optional<class_2960> getFamily() {
        return Optional.ofNullable(this.family);
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public RenderLayer getRenderLayer() {
        return this.renderLayer;
    }

    public class_8177 getBlockSetType() {
        return this.blockSetType;
    }

    public class_4719 getWoodType() {
        return this.woodType;
    }

    public Textures textures() {
        if (this.textures == null || this.textures.isEmpty()) {
            return Textures.NONE;
        }
        return this.textures.build();
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public <T> T get(String key, Class<T> type) {
        Object o = this.extradata.get(key);
        if (o == null) {
            throw new InitializationException(new NullPointerException(key + ": value is null"));
        }
        if (!type.isInstance(o)) {
            throw new InitializationException(new ClassCastException(key + ": expected " + String.valueOf(type) + " but found " + String.valueOf(o.getClass())));
        }
        return type.cast(o);
    }

    public <T> T getOrDefault(String key, Class<T> type, T defaultValue) {
        Object o = this.extradata.get(key);
        if (o == null) {
            return defaultValue;
        }
        if (!type.isInstance(o)) {
            throw new InitializationException(new ClassCastException(key + ": expected " + String.valueOf(type) + " but found " + String.valueOf(o.getClass())));
        }
        return type.cast(o);
    }

    public Props manual() {
        this.manual = true;
        return this;
    }

    public Props parent(class_2680 state) {
        this.parent = state;
        return this;
    }

    public Props family(String namespace, String name) {
        if (this.parent == null) {
            this.parent = ((class_2248)class_7923.field_41175.method_10223(new class_2960(namespace, name))).method_9564();
        }
        this.family = new class_2960(namespace, name);
        this.familyFactory = DeferredFamilyRegistry.BLOCKS;
        return this;
    }

    public Props family(String name) {
        String[] parts = name.split(":");
        if (parts.length == 2) {
            return this.family(parts[0], parts[1]);
        }
        return this.family(Context.getInstance().getNamespace(), name);
    }

    public Props name(String namespace, String plural, String singular) {
        return this.name(BlockName.of(namespace, plural, singular));
    }

    public Props name(String plural, String singular) {
        return this.name(Context.getInstance().getNamespace(), plural, singular);
    }

    public Props name(String name) {
        return this.name(Context.getInstance().getNamespace(), name, name);
    }

    public Props name(BlockName name) {
        this.name = name;
        return this;
    }

    public Props grassColor() {
        this.colorType = ColorType.GRASS;
        return this;
    }

    public Props foliageColor() {
        this.colorType = ColorType.FOLIAGE;
        return this;
    }

    public Props waterColor() {
        this.colorType = ColorType.WATER;
        return this;
    }

    public Props render(RenderLayer layer) {
        this.renderLayer = layer;
        return this;
    }

    public Props blockSetType(class_8177 type) {
        this.blockSetType = type;
        return this;
    }

    public Props woodType(class_4719 type) {
        this.woodType = type;
        return this;
    }

    public Props texture(String texture) {
        return this.texture("*", texture);
    }

    public Props texture(String name, String texture) {
        int j;
        String namespace = Context.getInstance().getNamespace();
        Object path = texture;
        int i = texture.indexOf(58);
        if (i != -1) {
            namespace = texture.substring(0, i);
            path = texture.substring(i + 1);
        }
        if ((j = ((String)path).indexOf(47)) == -1) {
            path = "block/" + (String)path;
        }
        if (this.textures == null) {
            this.textures = Textures.builder();
        }
        this.textures.add(name, Props.withNamespace(namespace, (String)path));
        return this;
    }

    public Props template(BlockTemplate template) {
        if (this.getRenderLayer().isCutout() || template.getRenderLayer().isCutout()) {
            Props props = new Props(this);
            props.solid(false);
            return props;
        }
        return this;
    }

    public Props with(String key, Object data) {
        if (this.extradata.isEmpty()) {
            this.extradata = new HashMap<String, Object>();
        }
        this.extradata.put(key, data);
        return this;
    }

    public Props variantFamily() {
        this.familyFactory = FamilyFactory.of(VariantFamily::new);
        return this;
    }

    public static Props create(class_2248 block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block must not be null");
        return new Props(block);
    }

    public static Props create(class_2680 state) {
        Preconditions.checkNotNull((Object)state, (Object)"BlockState must not be null");
        return Props.create(state.method_26204());
    }

    private static String withNamespace(String namespace, String name) {
        if (name.indexOf(58) != -1) {
            return name;
        }
        return namespace + ":" + name;
    }
}

