/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.data;

import com.conquestrefabricated.content.blocks.block.Cube;
import com.conquestrefabricated.content.blocks.block.VerticalCorner;
import com.conquestrefabricated.content.blocks.block.VerticalQuarter;
import com.conquestrefabricated.content.blocks.block.trees.BranchLarge;
import com.conquestrefabricated.core.block.data.BlockDataRegistry;
import com.conquestrefabricated.core.util.RenderLayer;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class WorldPainterGenerator {
    public static void run() {
        try (Writer blocks = WorldPainterGenerator.newWriter("conquest_wp.csv");){
            blocks.append("name,discriminator,properties,opacity,receivesLight,insubstantial,resource,tileEntity,tileEntityId,treeRelated,vegetation,blockLight,natural,watery,colour,horizontal_orientation_schemes,vertical_orientation_scheme\n");
            BlockDataRegistry.getInstance().getData("conquest").forEach(blockData -> {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockData.getRegistryName());
                try {
                    class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                    WorldPainterGenerator.appendBlock(block, blocks);
                    blocks.append(',');
                    blocks.append(',');
                    WorldPainterGenerator.appendState(block.method_9564(), blocks);
                    blocks.append(',');
                    int opacity = block.method_9564().method_26225() ? 15 : 0;
                    blocks.append(opacity + ",");
                    boolean receivesLight = blockData.getProps().getRenderLayer() == RenderLayer.SOLID && !(block instanceof Cube);
                    blocks.append(receivesLight + ",");
                    boolean isVegetation = !(block instanceof BranchLarge) && (block.method_9564().method_45474() || blockId.method_12832().contains("rocks") || blockId.method_12832().contains("leaves") || block.method_9564().method_26231() == class_2498.field_11535 && blockId.method_12832().contains("leaf") || blockId.method_12832().contains("needles") || blockId.method_12832().contains("blossoms") || blockId.method_12832().contains("lilac") || blockId.method_12832().contains("mistletoe") || blockId.method_12832().contains("tree") || blockId.method_12832().contains("cypress") || blockId.method_12832().contains("branch"));
                    blocks.append(isVegetation + ",");
                    blocks.append("false,");
                    blocks.append("false,");
                    blocks.append("false,");
                    boolean isTreeRelated = blockId.method_12832().contains("log") || blockId.method_12832().contains("branch") || blockId.method_12832().contains("tree") || blockId.method_12832().contains("sapling") || block.method_9564().method_26231() == class_2498.field_11535 && (blockId.method_12832().contains("leaves") || blockId.method_12832().contains("leaf") || blockId.method_12832().contains("needles") || blockId.method_12832().contains("blossoms") || blockId.method_12832().contains("lilac") || blockId.method_12832().contains("mistletoe") || blockId.method_12832().contains("tree") || blockId.method_12832().contains("cypress"));
                    blocks.append(isTreeRelated + ",");
                    blocks.append((isTreeRelated || isVegetation) + ",");
                    blocks.append(block.method_9564().method_26213() + ",");
                    blocks.append("true,");
                    blocks.append("false,");
                    block.method_26403();
                    int colorId = block.method_26403().field_16011;
                    blocks.append(colorId + ",");
                    blocks.append(block instanceof VerticalQuarter || block instanceof VerticalCorner ? "facing_asym," : ",");
                    blocks.append('\n');
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Writer newWriter(String name) throws IOException {
        return new BufferedWriter(new FileWriter(name));
    }

    private static void appendBlock(class_2248 block, Writer writer) throws IOException {
        if (class_7923.field_41175.method_10221((Object)block) != null) {
            writer.append(class_7923.field_41175.method_10221((Object)block).toString());
        }
    }

    private static void appendState(class_2680 state, Writer writer) throws IOException {
        if (!state.method_28501().isEmpty()) {
            writer.append('\"');
            boolean first = true;
            for (class_2769 e : state.method_28501()) {
                if (!first) {
                    writer.append(',');
                }
                if (e.method_11902() == Boolean.class) {
                    writer.append(e.method_11899()).append(":b");
                } else if (e.method_11902() == Integer.class) {
                    int min = (Integer)Collections.min(e.method_11898());
                    int max = (Integer)Collections.max(e.method_11898());
                    writer.append(e.method_11899()).append(":i[" + min + "-" + max + "]");
                } else {
                    writer.append(e.method_11899()).append(":e" + e.method_11898().toString().replace(", ", ";"));
                }
                first = false;
            }
            writer.append('\"');
        }
    }
}

