/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item;

import com.conquestrefabricated.core.item.family.Family;
import com.conquestrefabricated.core.item.family.FamilyRegistry;
import com.conquestrefabricated.core.item.family.TypeFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7706;

public class ItemUtils {
    public static final String BLOCK_STATE_TAG = "BlockStateTag";

    public static class_1799 fromState(class_2680 state) {
        class_1799 stack = new class_1799((class_1935)state.method_26204());
        class_2487 data = stack.method_7911(BLOCK_STATE_TAG);
        for (Map.Entry e : state.method_11656().entrySet()) {
            data.method_10582(((class_2769)e.getKey()).method_11899(), e.getValue().toString());
        }
        return stack;
    }

    public static class_1799 fromStateNoFacing(class_2680 state) {
        class_1799 stack = new class_1799((class_1935)state.method_26204());
        class_2487 data = stack.method_7911(BLOCK_STATE_TAG);
        for (Map.Entry e : state.method_11656().entrySet()) {
            if (Objects.equals(((class_2769)e.getKey()).method_11899(), "facing")) continue;
            data.method_10582(((class_2769)e.getKey()).method_11899(), e.getValue().toString());
        }
        return stack;
    }

    public static class_1799 fromState(class_2680 state, class_2769<?> property) {
        String value = state.method_11654(property).toString();
        class_1799 stack = new class_1799((class_1935)state.method_26204());
        stack.method_7911(BLOCK_STATE_TAG).method_10582(property.method_11899(), value);
        stack.method_7977(class_2561.method_30163((String)(stack.method_7954().getString() + property.method_11899() + "=" + value)));
        return stack;
    }

    public static class_1799 fromState(class_2680 state, Collection<class_2769<?>> properties) {
        StringBuilder name = new StringBuilder("[");
        class_1799 stack = new class_1799((class_1935)state.method_26204());
        class_2487 stateTag = stack.method_7911(BLOCK_STATE_TAG);
        for (class_2769<?> property : properties) {
            if (!state.method_28498(property)) continue;
            String value = state.method_11654(property).toString();
            stateTag.method_10582(property.method_11899(), value);
            if (name.length() > 1) {
                name.append(',');
            }
            name.append(property.method_11899()).append('=').append(value);
        }
        if (name.length() > 1) {
            name.append("]");
            stack.method_7977(class_2561.method_30163((String)(stack.method_7954().getString() + name.toString())));
        }
        return stack;
    }

    public static <T extends class_1792> Optional<T> toItem(class_1792 item, Class<T> t) {
        return t.isInstance(item) ? Optional.of((class_1792)t.cast(item)) : Optional.empty();
    }

    public static class_2371<class_1799> getFamilyItems(class_1799 stack) {
        return ItemUtils.getFamilyItems(stack, TypeFilter.ANY);
    }

    public static class_2371<class_1799> getFamilyItems(class_1799 stack, TypeFilter filter) {
        class_2371 items = class_2371.method_10211();
        ItemUtils.getFamily(stack).addAllItems(class_7706.method_47344(), (class_2371<class_1799>)items, filter);
        if (items.isEmpty()) {
            items.add((Object)stack);
        }
        return items;
    }

    public static Family<class_2248> getFamily(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_2248 block = class_2246.field_10124;
        if (item instanceof class_1747) {
            block = ((class_1747)item).method_7711();
        }
        return FamilyRegistry.BLOCKS.getFamily(block);
    }
}

