/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.core.item.family;

import com.conquestrefabricated.core.item.family.Family;
import com.conquestrefabricated.core.item.family.FamilyRegistry;
import com.conquestrefabricated.core.item.group.ConquestItemGroup;
import com.conquestrefabricated.core.item.group.TaggedGroup;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public class FamilyGroup
extends TaggedGroup<FamilyGroup> {
    public static final List<FamilyGroup> FAMILY_GROUPS = new LinkedList<FamilyGroup>();
    private static final Family.Filler ALL_ITEMS = Family::addAllItems;
    private static final Family.Filler ROOT_ITEMS = Family::addRootItem;
    private static Family.Filler filler = Family::addAllItems;
    private final Supplier<class_1799> icon;

    public FamilyGroup(int order, String label, Supplier<class_1799> icon, class_1761.class_7915 row, int column, class_1761.class_7916 type, class_2561 text, class_1761.class_7914 entryCollector) {
        super(order, label, row, column, type, text, icon, entryCollector);
        this.icon = icon;
        FAMILY_GROUPS.add(this);
    }

    @Override
    public FamilyGroup self() {
        return this;
    }

    @Override
    public void populate(class_2371<class_1799> items) {
        FamilyRegistry.BLOCKS.values().forEach(family -> filler.fill((Family)family, this, items));
        FamilyRegistry.ITEMS.values().forEach(family -> filler.fill((Family)family, this, items));
    }

    public static void setAddAllItems() {
        if (filler != ALL_ITEMS) {
            filler = ALL_ITEMS;
            FAMILY_GROUPS.forEach(ConquestItemGroup::invalidate);
        }
    }

    public static void setAddRootItems() {
        if (filler != ROOT_ITEMS) {
            filler = ROOT_ITEMS;
            FAMILY_GROUPS.forEach(ConquestItemGroup::invalidate);
        }
    }

    public static Stream<FamilyGroup> stream() {
        return FAMILY_GROUPS.stream().sorted(Comparator.comparing(ConquestItemGroup::getOrderIndex));
    }
}

