/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.commands;

import itzazeem.asclan.AsClan;
import itzazeem.asclan.models.Clan;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClanCommand
implements CommandExecutor {
    private final AsClan plugin;

    public ClanCommand(AsClan plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("asclan.use")) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(sender, args);
                break;
            }
            case "disband": {
                this.handleDisband(sender);
                break;
            }
            case "invite": {
                this.handleInvite(sender, args);
                break;
            }
            case "accept": {
                this.handleAccept(sender);
                break;
            }
            case "kick": {
                this.handleKick(sender, args);
                break;
            }
            case "chat": {
                this.handleChat(sender);
                break;
            }
            case "sethome": {
                this.handleSetHome(sender);
                break;
            }
            case "home": {
                this.handleHome(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender, args);
                break;
            }
            case "war": {
                this.handleWar(sender, args);
                break;
            }
            case "top": {
                this.handleTop(sender);
                break;
            }
            case "point": 
            case "points": {
                this.handlePoints(sender);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void handleCreate(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cUsage: /clan create <name>");
            return;
        }
        Player player = (Player)sender;
        String clanName = args[1];
        if (this.plugin.getClanManager().isInClan(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("already-in-clan"));
            return;
        }
        int minLength = this.plugin.getConfigManager().getMinNameLength();
        int maxLength = this.plugin.getConfigManager().getMaxNameLength();
        if (clanName.length() < minLength || clanName.length() > maxLength) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("invalid-name", "min", String.valueOf(minLength), "max", String.valueOf(maxLength)));
            return;
        }
        if (this.plugin.getClanManager().createClan(player, clanName)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-created", "clan", clanName));
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-exists"));
        }
    }

    private void handleDisband(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getClanManager().isInClan(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        if (this.plugin.getClanManager().disbandClan(player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-disbanded"));
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-leader"));
        }
    }

    private void handleInvite(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cUsage: /clan invite <player>");
            return;
        }
        Player player = (Player)sender;
        Clan clan = this.plugin.getClanManager().getClan(player.getUniqueId());
        if (clan == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        if (!clan.isLeader(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-leader"));
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cPlayer not found!");
            return;
        }
        if (this.plugin.getClanManager().isInClan(target.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cThat player is already in a clan!");
            return;
        }
        if (clan.getMemberCount() >= this.plugin.getConfigManager().getMaxMembers()) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("member-limit"));
            return;
        }
        this.plugin.getClanManager().invitePlayer(player, target);
        sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-invited", "player", target.getName()));
        target.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("invite-sent", "clan", clan.getName()));
    }

    private void handleAccept(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        if (this.plugin.getClanManager().isInClan(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("already-in-clan"));
            return;
        }
        if (!this.plugin.getClanManager().hasPendingInvite(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("no-invite"));
            return;
        }
        String clanName = this.plugin.getClanManager().getPendingInviteClan(player.getUniqueId());
        Clan clan = this.plugin.getClanManager().getClanByName(clanName);
        if (this.plugin.getClanManager().acceptInvite(player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("invite-accepted"));
            for (UUID member : clan.getMembers()) {
                Player memberPlayer = Bukkit.getPlayer((UUID)member);
                if (memberPlayer == null || memberPlayer.equals(player)) continue;
                memberPlayer.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("member-joined", "player", player.getName()));
            }
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("member-limit"));
        }
    }

    private void handleKick(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cUsage: /clan kick <player>");
            return;
        }
        Player player = (Player)sender;
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cPlayer not found!");
            return;
        }
        if (this.plugin.getClanManager().kickMember(player, target)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-kicked", "player", target.getName()));
            target.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cYou have been kicked from the clan!");
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cCannot kick that player!");
        }
    }

    private void handleChat(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        if (!this.plugin.getClanManager().isInClan(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        this.plugin.getClanManager().toggleClanChat(player.getUniqueId());
        if (this.plugin.getClanManager().isClanChatEnabled(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-chat-enabled"));
        } else {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-chat-disabled"));
        }
    }

    private void handleSetHome(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        Clan clan = this.plugin.getClanManager().getClan(player.getUniqueId());
        if (clan == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        if (!clan.isLeader(player.getUniqueId())) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-leader"));
            return;
        }
        clan.setHome(player.getLocation());
        this.plugin.getDataManager().saveClans();
        sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("home-set"));
    }

    private void handleHome(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        Clan clan = this.plugin.getClanManager().getClan(player.getUniqueId());
        if (clan == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        if (clan.getHome() == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cClan home has not been set!");
            return;
        }
        sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("teleporting"));
        player.teleport(clan.getHome());
    }

    private void handleInfo(CommandSender sender, String[] args) {
        Clan clan;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        if (args.length > 1) {
            clan = this.plugin.getClanManager().getClanByName(args[1]);
            if (clan == null) {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("clan-not-found"));
                return;
            }
        } else {
            clan = this.plugin.getClanManager().getClan(player.getUniqueId());
            if (clan == null) {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
                return;
            }
        }
        this.displayClanInfo(sender, clan);
    }

    private void displayClanInfo(CommandSender sender, Clan clan) {
        Player leader = Bukkit.getPlayer((UUID)clan.getLeader());
        String leaderName = leader != null ? leader.getName() : "Offline";
        Date createdDate = new Date(clan.getCreated());
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        sender.sendMessage("&8&m--------&r &6Clan Info &8&m--------");
        sender.sendMessage("&eName: &f" + clan.getName());
        sender.sendMessage("&eLeader: &f" + leaderName);
        sender.sendMessage("&eMembers: &f" + clan.getMemberCount() + "/" + this.plugin.getConfigManager().getMaxMembers());
        sender.sendMessage("&ePoints: &f" + clan.getPoints());
        sender.sendMessage("&eCreated: &f" + dateFormat.format(createdDate));
        sender.sendMessage("&eHome: &f" + (clan.getHome() != null ? "Set" : "Not Set"));
        StringBuilder members = new StringBuilder("&eMembers: &f");
        for (UUID memberUuid : clan.getMembers()) {
            String memberName;
            Player memberPlayer = Bukkit.getPlayer((UUID)memberUuid);
            String string = memberName = memberPlayer != null ? memberPlayer.getName() : "Offline";
            if (clan.isLeader(memberUuid)) {
                members.append("&6").append(memberName).append("&f, ");
                continue;
            }
            members.append(memberName).append(", ");
        }
        String memberList = members.toString();
        if (memberList.endsWith(", ")) {
            memberList = memberList.substring(0, memberList.length() - 2);
        }
        sender.sendMessage(memberList);
    }

    private void handleWar(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cUsage: /clan war <clan> or /clan war accept");
            return;
        }
        Player player = (Player)sender;
        String subCommand = args[1].toLowerCase();
        if (subCommand.equals("accept")) {
            if (this.plugin.getWarManager().acceptWar(player)) {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&aWar accepted! Prepare for battle!");
            } else {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cNo war challenge found or you're not the leader!");
            }
        } else {
            String targetClan = args[1];
            if (this.plugin.getWarManager().challengeClan(player, targetClan)) {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("war-challenge-sent", "clan", targetClan));
            } else {
                sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&cCannot challenge that clan!");
            }
        }
    }

    private void handleTop(CommandSender sender) {
        List<Clan> topClans = this.plugin.getClanManager().getTopClans(10);
        sender.sendMessage("&8&m--------&r &6Top Clans &8&m--------");
        if (topClans.isEmpty()) {
            sender.sendMessage("&cNo clans found!");
            return;
        }
        int position = 1;
        for (Clan clan : topClans) {
            sender.sendMessage("&e" + position + ". &f" + clan.getName() + " &8- &6" + clan.getPoints() + " points");
            ++position;
        }
    }

    private void handlePoints(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("player-only"));
            return;
        }
        Player player = (Player)sender;
        Clan clan = this.plugin.getClanManager().getClan(player.getUniqueId());
        if (clan == null) {
            sender.sendMessage(this.plugin.getConfigManager().getPrefix() + this.plugin.getConfigManager().getMessage("not-in-clan"));
            return;
        }
        sender.sendMessage(this.plugin.getConfigManager().getPrefix() + "&eClan Points: &f" + clan.getPoints());
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage("&8&m--------&r &6AsClan Commands &8&m--------");
        sender.sendMessage("&e/clan create <name> &8- &fCreate a clan");
        sender.sendMessage("&e/clan disband &8- &fDisband your clan");
        sender.sendMessage("&e/clan invite <player> &8- &fInvite a player");
        sender.sendMessage("&e/clan accept &8- &fAccept clan invite");
        sender.sendMessage("&e/clan kick <player> &8- &fKick a member");
        sender.sendMessage("&e/clan chat &8- &fToggle clan chat");
        sender.sendMessage("&e/clan sethome &8- &fSet clan home");
        sender.sendMessage("&e/clan home &8- &fTeleport to clan home");
        sender.sendMessage("&e/clan info [clan] &8- &fView clan info");
        sender.sendMessage("&e/clan war <clan> &8- &fChallenge a clan");
        sender.sendMessage("&e/clan war accept &8- &fAccept war challenge");
        sender.sendMessage("&e/clan top &8- &fView top clans");
        sender.sendMessage("&e/clan point &8- &fView clan points");
    }
}

