/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.commands;

import itzazeem.asclan.AsClan;
import itzazeem.asclan.models.Clan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ClanTabCompleter
implements TabCompleter {
    private final AsClan plugin;

    public ClanTabCompleter(AsClan plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subCommands = Arrays.asList("create", "disband", "invite", "accept", "kick", "chat", "sethome", "home", "info", "war", "top", "point", "points");
            return subCommands.stream().filter(cmd -> cmd.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String subCommand;
            switch (subCommand = args[0].toLowerCase()) {
                case "create": {
                    return new ArrayList<String>();
                }
                case "invite": {
                    return this.getOnlinePlayersNotInClan(args[1]);
                }
                case "kick": {
                    return this.getClanMembers(sender, args[1], false);
                }
                case "info": {
                    return this.getAllClanNames(args[1]);
                }
                case "war": {
                    ArrayList<String> warOptions = new ArrayList<String>();
                    warOptions.add("accept");
                    warOptions.addAll(this.getOtherClanNames(sender, args[1]));
                    return warOptions.stream().filter(option -> option.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
                }
            }
            return new ArrayList<String>();
        }
        return completions;
    }

    private List<String> getOnlinePlayersNotInClan(String partial) {
        return Bukkit.getOnlinePlayers().stream().filter(player -> !this.plugin.getClanManager().isInClan(player.getUniqueId())).map(Player::getName).filter(name -> name.toLowerCase().startsWith(partial.toLowerCase())).collect(Collectors.toList());
    }

    private List<String> getClanMembers(CommandSender sender, String partial, boolean includeLeader) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        Clan clan = this.plugin.getClanManager().getClan(player.getUniqueId());
        if (clan == null) {
            return new ArrayList<String>();
        }
        return clan.getMembers().stream().filter(uuid -> includeLeader || !clan.isLeader((UUID)uuid)).map(Bukkit::getPlayer).filter(p -> p != null).map(Player::getName).filter(name -> name.toLowerCase().startsWith(partial.toLowerCase())).collect(Collectors.toList());
    }

    private List<String> getAllClanNames(String partial) {
        return this.plugin.getClanManager().getAllClans().stream().map(Clan::getName).filter(name -> name.toLowerCase().startsWith(partial.toLowerCase())).collect(Collectors.toList());
    }

    private List<String> getOtherClanNames(CommandSender sender, String partial) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        Clan playerClan = this.plugin.getClanManager().getClan(player.getUniqueId());
        return this.plugin.getClanManager().getAllClans().stream().filter(clan -> playerClan == null || !clan.getName().equals(playerClan.getName())).map(Clan::getName).filter(name -> name.toLowerCase().startsWith(partial.toLowerCase())).collect(Collectors.toList());
    }
}

