/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.managers;

import itzazeem.asclan.AsClan;
import itzazeem.asclan.models.Clan;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class ClanManager {
    private final AsClan plugin;
    private final Map<String, Clan> clans;
    private final Map<UUID, String> playerClans;
    private final Map<UUID, String> pendingInvites;
    private final Set<UUID> clanChatEnabled;

    public ClanManager(AsClan plugin) {
        this.plugin = plugin;
        this.clans = new ConcurrentHashMap<String, Clan>();
        this.playerClans = new ConcurrentHashMap<UUID, String>();
        this.pendingInvites = new ConcurrentHashMap<UUID, String>();
        this.clanChatEnabled = ConcurrentHashMap.newKeySet();
    }

    public boolean createClan(Player player, String name) {
        if (this.isInClan(player.getUniqueId())) {
            return false;
        }
        if (this.clans.containsKey(name.toLowerCase())) {
            return false;
        }
        Clan clan = new Clan(name, player.getUniqueId());
        this.clans.put(name.toLowerCase(), clan);
        this.playerClans.put(player.getUniqueId(), name.toLowerCase());
        this.plugin.getDataManager().saveClans();
        return true;
    }

    public boolean disbandClan(Player player) {
        String clanName = this.playerClans.get(player.getUniqueId());
        if (clanName == null) {
            return false;
        }
        Clan clan = this.clans.get(clanName);
        if (clan == null || !clan.isLeader(player.getUniqueId())) {
            return false;
        }
        for (UUID member : clan.getMembers()) {
            this.playerClans.remove(member);
            this.clanChatEnabled.remove(member);
        }
        this.clans.remove(clanName);
        this.plugin.getDataManager().saveClans();
        return true;
    }

    public void invitePlayer(Player inviter, Player target) {
        String clanName = this.playerClans.get(inviter.getUniqueId());
        if (clanName != null) {
            this.pendingInvites.put(target.getUniqueId(), clanName);
        }
    }

    public boolean acceptInvite(Player player) {
        String clanName = this.pendingInvites.remove(player.getUniqueId());
        if (clanName == null) {
            return false;
        }
        Clan clan = this.clans.get(clanName);
        if (clan == null) {
            return false;
        }
        int maxMembers = this.plugin.getConfig().getInt("clan.max-members", 10);
        if (clan.getMemberCount() >= maxMembers) {
            return false;
        }
        clan.addMember(player.getUniqueId());
        this.playerClans.put(player.getUniqueId(), clanName);
        this.plugin.getDataManager().saveClans();
        return true;
    }

    public boolean kickMember(Player kicker, Player target) {
        String clanName = this.playerClans.get(kicker.getUniqueId());
        if (clanName == null) {
            return false;
        }
        Clan clan = this.clans.get(clanName);
        if (clan == null || !clan.isLeader(kicker.getUniqueId())) {
            return false;
        }
        if (!clan.isMember(target.getUniqueId()) || clan.isLeader(target.getUniqueId())) {
            return false;
        }
        clan.removeMember(target.getUniqueId());
        this.playerClans.remove(target.getUniqueId());
        this.clanChatEnabled.remove(target.getUniqueId());
        this.plugin.getDataManager().saveClans();
        return true;
    }

    public boolean isInClan(UUID player) {
        return this.playerClans.containsKey(player);
    }

    public Clan getClan(UUID player) {
        String clanName = this.playerClans.get(player);
        return clanName != null ? this.clans.get(clanName) : null;
    }

    public Clan getClanByName(String name) {
        return this.clans.get(name.toLowerCase());
    }

    public boolean hasPendingInvite(UUID player) {
        return this.pendingInvites.containsKey(player);
    }

    public String getPendingInviteClan(UUID player) {
        return this.pendingInvites.get(player);
    }

    public boolean isClanChatEnabled(UUID player) {
        return this.clanChatEnabled.contains(player);
    }

    public void toggleClanChat(UUID player) {
        if (this.clanChatEnabled.contains(player)) {
            this.clanChatEnabled.remove(player);
        } else {
            this.clanChatEnabled.add(player);
        }
    }

    public List<Clan> getTopClans(int limit) {
        return this.clans.values().stream().sorted((a, b) -> Integer.compare(b.getPoints(), a.getPoints())).limit(limit).toList();
    }

    public void loadClan(String name, Clan clan) {
        this.clans.put(name.toLowerCase(), clan);
        for (UUID member : clan.getMembers()) {
            this.playerClans.put(member, name.toLowerCase());
        }
    }

    public Collection<Clan> getAllClans() {
        return this.clans.values();
    }

    public void clearData() {
        this.clans.clear();
        this.playerClans.clear();
        this.pendingInvites.clear();
        this.clanChatEnabled.clear();
    }
}

