/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.managers;

import itzazeem.asclan.AsClan;
import org.bukkit.ChatColor;

public class ConfigManager {
    private final AsClan plugin;

    public ConfigManager(AsClan plugin) {
        this.plugin = plugin;
    }

    public String getMessage(String key) {
        String message = this.plugin.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, String ... replacements) {
        String message = this.getMessage(key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        return message;
    }

    public String getPrefix() {
        return this.getMessage("prefix");
    }

    public int getMaxMembers() {
        return this.plugin.getConfig().getInt("clan.max-members", 10);
    }

    public int getMaxNameLength() {
        return this.plugin.getConfig().getInt("clan.max-name-length", 16);
    }

    public int getMinNameLength() {
        return this.plugin.getConfig().getInt("clan.min-name-length", 3);
    }

    public int getHomeCooldown() {
        return this.plugin.getConfig().getInt("clan.home-cooldown", 5);
    }

    public int getWarDuration() {
        return this.plugin.getConfig().getInt("clan.war-duration", 300);
    }

    public int getKillReward() {
        return this.plugin.getConfig().getInt("points.kill-reward", 5);
    }

    public int getDeathPenalty() {
        return this.plugin.getConfig().getInt("points.death-penalty", 1);
    }

    public int getWarWinReward() {
        return this.plugin.getConfig().getInt("points.war-win-reward", 50);
    }

    public int getWarLosePenalty() {
        return this.plugin.getConfig().getInt("points.war-lose-penalty", 25);
    }
}

