/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.managers;

import itzazeem.asclan.AsClan;
import itzazeem.asclan.models.Clan;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final AsClan plugin;
    private final File dataFile;
    private FileConfiguration dataConfig;

    public DataManager(AsClan plugin) {
        this.plugin = plugin;
        this.dataFile = new File(plugin.getDataFolder(), "clans.yml");
        this.loadDataFile();
    }

    private void loadDataFile() {
        if (!this.dataFile.exists()) {
            this.plugin.saveResource("clans.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveClans() {
        try {
            this.dataConfig.set("clans", null);
            for (Clan clan : this.plugin.getClanManager().getAllClans()) {
                this.dataConfig.set("clans." + clan.getName().toLowerCase(), clan.serialize());
            }
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save clans data: " + e.getMessage());
        }
    }

    public void loadClans() {
        this.plugin.getClanManager().clearData();
        if (!this.dataConfig.contains("clans")) {
            return;
        }
        for (String clanName : this.dataConfig.getConfigurationSection("clans").getKeys(false)) {
            try {
                Map clanData = this.dataConfig.getConfigurationSection("clans." + clanName).getValues(false);
                Clan clan = new Clan(clanData);
                this.plugin.getClanManager().loadClan(clanName, clan);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not load clan " + clanName + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Loaded " + this.plugin.getClanManager().getAllClans().size() + " clans");
    }
}

