/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.managers;

import itzazeem.asclan.AsClan;
import itzazeem.asclan.models.Clan;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WarManager {
    private final AsClan plugin;
    private final Map<String, String> warChallenges;
    private final Map<String, Long> activewars;

    public WarManager(AsClan plugin) {
        this.plugin = plugin;
        this.warChallenges = new HashMap<String, String>();
        this.activewars = new HashMap<String, Long>();
    }

    public boolean challengeClan(Player challenger, String targetClanName) {
        Clan challengerClan = this.plugin.getClanManager().getClan(challenger.getUniqueId());
        if (challengerClan == null || !challengerClan.isLeader(challenger.getUniqueId())) {
            return false;
        }
        Clan targetClan = this.plugin.getClanManager().getClanByName(targetClanName);
        if (targetClan == null) {
            return false;
        }
        if (challengerClan.getName().equalsIgnoreCase(targetClan.getName())) {
            return false;
        }
        this.warChallenges.put(challengerClan.getName().toLowerCase(), targetClan.getName().toLowerCase());
        Player targetLeader = Bukkit.getPlayer((UUID)targetClan.getLeader());
        if (targetLeader != null) {
            String message = this.plugin.getConfigManager().getMessage("war-challenge-received", "clan", challengerClan.getName());
            targetLeader.sendMessage(this.plugin.getConfigManager().getPrefix() + message);
        }
        return true;
    }

    public boolean acceptWar(Player accepter) {
        Clan accepterClan = this.plugin.getClanManager().getClan(accepter.getUniqueId());
        if (accepterClan == null || !accepterClan.isLeader(accepter.getUniqueId())) {
            return false;
        }
        String challengerClanName = null;
        for (Map.Entry<String, String> entry : this.warChallenges.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(accepterClan.getName())) continue;
            challengerClanName = entry.getKey();
            break;
        }
        if (challengerClanName == null) {
            return false;
        }
        this.warChallenges.remove(challengerClanName);
        String warKey = challengerClanName + "-" + accepterClan.getName().toLowerCase();
        this.activewars.put(warKey, System.currentTimeMillis());
        this.notifyWarStart(challengerClanName, accepterClan.getName());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.endWar(warKey), (long)this.plugin.getConfigManager().getWarDuration() * 20L);
        return true;
    }

    private void notifyWarStart(String clan1, String clan2) {
        Player player;
        Clan challengerClan = this.plugin.getClanManager().getClanByName(clan1);
        Clan targetClan = this.plugin.getClanManager().getClanByName(clan2);
        String message = "&6War has started between &e" + challengerClan.getName() + " &6and &e" + targetClan.getName() + "&6!";
        for (UUID member : challengerClan.getMembers()) {
            player = Bukkit.getPlayer((UUID)member);
            if (player == null) continue;
            player.sendMessage(this.plugin.getConfigManager().getPrefix() + message);
        }
        for (UUID member : targetClan.getMembers()) {
            player = Bukkit.getPlayer((UUID)member);
            if (player == null) continue;
            player.sendMessage(this.plugin.getConfigManager().getPrefix() + message);
        }
    }

    private void endWar(String warKey) {
        this.activewars.remove(warKey);
        String[] clans = warKey.split("-");
        String message = "&6War between &e" + clans[0] + " &6and &e" + clans[1] + " &6has ended!";
        Clan clan1 = this.plugin.getClanManager().getClanByName(clans[0]);
        Clan clan2 = this.plugin.getClanManager().getClanByName(clans[1]);
        if (clan1 != null && clan2 != null) {
            this.notifyWarEnd(clan1, clan2);
        }
    }

    private void notifyWarEnd(Clan clan1, Clan clan2) {
        Player player;
        String message = "&6War has ended!";
        for (UUID member : clan1.getMembers()) {
            player = Bukkit.getPlayer((UUID)member);
            if (player == null) continue;
            player.sendMessage(this.plugin.getConfigManager().getPrefix() + message);
        }
        for (UUID member : clan2.getMembers()) {
            player = Bukkit.getPlayer((UUID)member);
            if (player == null) continue;
            player.sendMessage(this.plugin.getConfigManager().getPrefix() + message);
        }
    }

    public boolean hasChallenge(String clanName) {
        return this.warChallenges.containsValue(clanName.toLowerCase());
    }

    public boolean isInWar(String clanName) {
        for (String warKey : this.activewars.keySet()) {
            if (!warKey.contains(clanName.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

