/*
 * Decompiled with CFR 0.152.
 */
package itzazeem.asclan.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class Clan
implements ConfigurationSerializable {
    private String name;
    private String tag;
    private UUID leader;
    private Set<UUID> members;
    private Location home;
    private long created;
    private int points;
    private Map<String, Object> warData;

    public Clan(String name, UUID leader) {
        this.name = name;
        this.leader = leader;
        this.members = new HashSet<UUID>();
        this.members.add(leader);
        this.created = System.currentTimeMillis();
        this.points = 0;
        this.warData = new HashMap<String, Object>();
    }

    public Clan(Map<String, Object> map) {
        this.name = (String)map.get("name");
        this.tag = (String)map.get("tag");
        this.leader = UUID.fromString((String)map.get("leader"));
        List memberStrings = (List)map.get("members");
        this.members = new HashSet<UUID>();
        if (memberStrings != null) {
            for (String memberString : memberStrings) {
                this.members.add(UUID.fromString(memberString));
            }
        }
        this.home = (Location)map.get("home");
        this.created = (Long)map.getOrDefault("created", System.currentTimeMillis());
        this.points = (Integer)map.getOrDefault("points", 0);
        this.warData = map.getOrDefault("warData", new HashMap());
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("tag", this.tag);
        map.put("leader", this.leader.toString());
        ArrayList<String> memberStrings = new ArrayList<String>();
        for (UUID member : this.members) {
            memberStrings.add(member.toString());
        }
        map.put("members", memberStrings);
        map.put("home", this.home);
        map.put("created", this.created);
        map.put("points", this.points);
        map.put("warData", this.warData);
        return map;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public UUID getLeader() {
        return this.leader;
    }

    public void setLeader(UUID leader) {
        this.leader = leader;
    }

    public Set<UUID> getMembers() {
        return this.members;
    }

    public void addMember(UUID member) {
        this.members.add(member);
    }

    public void removeMember(UUID member) {
        this.members.remove(member);
    }

    public boolean isMember(UUID player) {
        return this.members.contains(player);
    }

    public boolean isLeader(UUID player) {
        return this.leader.equals(player);
    }

    public Location getHome() {
        return this.home;
    }

    public void setHome(Location home) {
        this.home = home;
    }

    public long getCreated() {
        return this.created;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void addPoints(int points) {
        this.points += points;
    }

    public void removePoints(int points) {
        this.points = Math.max(0, this.points - points);
    }

    public Map<String, Object> getWarData() {
        return this.warData;
    }

    public void setWarData(Map<String, Object> warData) {
        this.warData = warData;
    }

    public int getMemberCount() {
        return this.members.size();
    }
}

