/*
 * Decompiled with CFR 0.152.
 */
package org.tough_environment;

import btwr.btwr_sl.lib.util.BlockReplacementRegistry;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.minecraft.class_1794;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tough_environment.block.ModBlocks;
import org.tough_environment.config.TESettings;
import org.tough_environment.event.ModEvents;
import org.tough_environment.item.ModItemGroup;
import org.tough_environment.item.ModItems;
import org.tough_environment.loot.ModLootConditionTypes;
import org.tough_environment.registry.ModFuelItems;
import org.tough_environment.util.BlockMortarMapper;

public class ToughEnvironmentMod
implements ModInitializer {
    public static final String MOD_ID = "tough_environment";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tough_environment");
    public TESettings settings;
    private static ToughEnvironmentMod instance;

    public static ToughEnvironmentMod getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Tough Environment.");
        this.loadSettings();
        instance = this;
        ModBlocks.registerModBlocks();
        ModBlocks.registerItemsPlaceableAsBlocks();
        ModItems.registerModItems();
        ModItemGroup.registerItemGroups();
        ModFuelItems.register();
        ModLootConditionTypes.register();
        BlockMortarMapper.register();
        BlockReplacementRegistry.registerReplacement((class_2248)class_2246.field_10460, (class_2248)ModBlocks.CLAY_ORE);
        ModEvents.register();
        TillableBlockRegistry.register((class_2248)ModBlocks.DIRT_LOOSE, class_1794::method_36987, context -> {
            class_2680 result = class_2246.field_10362.method_9564();
            class_1794.method_36988((class_2680)result).accept(context);
        });
    }

    public void loadSettings() {
        File file = new File("./config/btwr/toughEnvironmentCommon.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (TESettings)gson.fromJson((Reader)fileReader, TESettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Tough Environment settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new TESettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/btwr/toughEnvironmentCommon.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Tough Environment settings: " + e.getLocalizedMessage());
        }
    }
}

