/*
 * Decompiled with CFR 0.152.
 */
package org.tough_environment.block;

import btwr.btwr_sl.tag.BTWRConventionalTags;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import org.tough_environment.block.ModBlocks;
import org.tough_environment.block.blocks.ConvertingBlock;
import org.tough_environment.block.blocks.DepletedStoneBlock;
import org.tough_environment.block.blocks.StoneConvertingBlock;
import org.tough_environment.tag.ModTags;

public class BlockBreakHandler {
    private static final BlockBreakHandler instance = new BlockBreakHandler();

    private BlockBreakHandler() {
    }

    public static BlockBreakHandler getInstance() {
        return instance;
    }

    public void setStateForStone(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 converted = this.getNextStateForVanillaStone(state, player.method_6047());
        if (converted == null) {
            return;
        }
        if (!player.method_7337()) {
            world.method_8501(pos, converted);
        } else {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
    }

    public void setStateForConvertedStone(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 converted = this.getNextStateForModdedStone(state, player.method_6047());
        if (converted == null) {
            return;
        }
        if (!player.method_7337()) {
            world.method_8501(pos, converted);
        } else {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
    }

    public void setStateForDirt(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_1799 tool = player.method_6047();
        if (tool.method_31573(BTWRConventionalTags.Items.SHOVELS_HARVEST_FULL_BLOCK) || player.method_7337()) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        } else {
            boolean isUpsideDown;
            boolean bl = isUpsideDown = state.method_26164(BTWRConventionalTags.Blocks.LOOSEN_ON_IMPROPER_BREAK_SLABS) && state.method_11654((class_2769)class_2741.field_12485) == class_2771.field_12679;
            if (state.method_26204() == ModBlocks.DIRT_LOOSE) {
                return;
            }
            this.onDirtDugWithImproperTool(world, pos);
            this.onDirtSlabDugWithImproperTool(world, pos, isUpsideDown);
        }
    }

    protected void onDirtDugWithImproperTool(class_1937 world, class_2338 pos) {
        for (class_2350 facing : class_2350.values()) {
            this.notifyNeighborDirtDugWithImproperTool(world, pos, facing);
        }
    }

    protected void onDirtSlabDugWithImproperTool(class_1937 world, class_2338 pos, boolean isUpsideDown) {
        for (class_2350 facing : class_2350.values()) {
            if (isUpsideDown && facing == class_2350.field_11033 || !isUpsideDown && facing == class_2350.field_11036) continue;
            this.notifyNeighborDirtDugWithImproperTool(world, pos, facing);
        }
    }

    protected void notifyNeighborDirtDugWithImproperTool(class_1937 world, class_2338 pos, class_2350 facing) {
        class_2338 neighborPos = pos.method_10093(facing);
        class_2680 state = world.method_8320(neighborPos);
        if (state != null) {
            this.onNeighborDirtDugWithImproperTool(world, neighborPos, facing.method_10153());
        }
    }

    protected void onNeighborDirtDugWithImproperTool(class_1937 world, class_2338 neighborPos, class_2350 facing) {
        class_2680 neighborState = world.method_8320(neighborPos);
        if (!neighborState.method_26164(BTWRConventionalTags.Blocks.LOOSEN_ON_IMPROPER_BREAK) && !neighborState.method_26164(BTWRConventionalTags.Blocks.LOOSEN_ON_IMPROPER_BREAK_SLABS)) {
            return;
        }
        if (neighborState.method_27852(class_2246.field_10219) || neighborState.method_27852(class_2246.field_10402)) {
            if (facing == class_2350.field_11033) {
                this.setToLooseDirt(world, neighborPos);
            }
        } else {
            this.setToLooseDirt(world, neighborPos);
        }
    }

    private void setToLooseDirt(class_1937 world, class_2338 neighborPos) {
        world.method_8652(neighborPos, ModBlocks.DIRT_LOOSE.method_9564(), 2);
    }

    public class_2680 getNextStateForVanillaStone(class_2680 state, class_1799 tool) {
        if (state.method_26164(ModTags.Blocks.STONE_ORES)) {
            return this.getConvertedOreState(state, tool, ModBlocks.STONE_CONVERTING);
        }
        if (state.method_26164(ModTags.Blocks.DEEPSLATE_ORES)) {
            return this.getConvertedOreState(state, tool, ModBlocks.DEEPSLATE_CONVERTING);
        }
        return this.getConvertedStoneState(state, tool);
    }

    public class_2680 getNextStateForModdedStone(class_2680 state, class_1799 tool) {
        int breakLevel = (Integer)state.method_11654((class_2769)ConvertingBlock.BREAK_LEVEL);
        boolean isModernChisel = tool.method_31573(BTWRConventionalTags.Items.MODERN_CHISELS);
        boolean isAdvancedChisel = tool.method_31573(BTWRConventionalTags.Items.ADVANCED_CHISELS);
        boolean isPrimitivePickaxe = tool.method_31573(BTWRConventionalTags.Items.PRIMITIVE_PICKAXES);
        boolean isModernPickaxe = tool.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES);
        boolean isAdvancedPickaxe = tool.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES);
        if (isAdvancedPickaxe || isModernPickaxe || isPrimitivePickaxe && breakLevel >= 5) {
            return class_2246.field_10124.method_9564();
        }
        if (isPrimitivePickaxe) {
            return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(5));
        }
        if (isModernChisel || isAdvancedChisel) {
            int nextBreakLevel = Math.min(breakLevel + 2, 8);
            if (breakLevel >= 7) {
                return ModBlocks.STONE_BROKEN.method_9564();
            }
            return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(nextBreakLevel));
        }
        if (breakLevel >= 8 && !(state.method_26204() instanceof DepletedStoneBlock) && state.method_26164(ModTags.Blocks.CONVERTED_STONE_BLOCKS)) {
            return ModBlocks.STONE_BROKEN.method_9564();
        }
        return this.getNextStateForConvertedBlocks(state, tool);
    }

    private class_2680 getNextStateForConvertedBlocks(class_2680 state, class_1799 tool) {
        return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)ConvertingBlock.BREAK_LEVEL) + 1));
    }

    public boolean shouldPlayCrackingSound(class_2680 state, class_1799 tool) {
        boolean isFullyBreakingPickaxe = tool.method_31573(BTWRConventionalTags.Items.PICKAXES_HARVEST_FULL_BLOCK);
        if (state.method_26204() instanceof StoneConvertingBlock && !state.method_26164(ModTags.Blocks.BROKEN_STONE_BLOCKS)) {
            int breakLevel = (Integer)state.method_11654((class_2769)ConvertingBlock.BREAK_LEVEL);
            return breakLevel % 2 == 0 && !isFullyBreakingPickaxe || breakLevel == 3 && this.isModernOrAdvancedChisel(tool);
        }
        if (state.method_26204() instanceof class_2431) {
            return !isFullyBreakingPickaxe;
        }
        return state.method_26164(ModTags.Blocks.STONE_STRATA1) && (this.isModernOrAdvancedChisel(tool) || tool.method_31573(BTWRConventionalTags.Items.PRIMITIVE_PICKAXES));
    }

    private class_2680 getConvertedOreState(class_2680 state, class_1799 tool, class_2248 convertingBlock) {
        if (!this.shouldConvertOre(state, tool)) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)convertingBlock.method_9564().method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(5));
    }

    private class_2680 getConvertedStoneState(class_2680 state, class_1799 tool) {
        HashMap<class_2248, class_2248> blockMap = new HashMap<class_2248, class_2248>();
        blockMap.put(class_2246.field_10340, ModBlocks.STONE_CONVERTING);
        blockMap.put(class_2246.field_10474, ModBlocks.GRANITE_CONVERTING);
        blockMap.put(class_2246.field_10115, ModBlocks.ANDESITE_CONVERTING);
        blockMap.put(class_2246.field_10508, ModBlocks.DIORITE_CONVERTING);
        blockMap.put(class_2246.field_27114, ModBlocks.CALCITE_CONVERTING);
        blockMap.put(class_2246.field_27165, ModBlocks.TUFF_CONVERTING);
        blockMap.put(class_2246.field_23869, ModBlocks.BLACKSTONE_CONVERTING);
        blockMap.put(class_2246.field_28888, ModBlocks.DEEPSLATE_CONVERTING);
        blockMap.put(class_2246.field_22091, ModBlocks.BASALT_CONVERTING);
        blockMap.put(class_2246.field_10471, ModBlocks.END_STONE_CONVERTING);
        for (Map.Entry entry : blockMap.entrySet()) {
            class_2248 originalBlock = (class_2248)entry.getKey();
            class_2248 convertedBlock = (class_2248)entry.getValue();
            if (!state.method_27852(originalBlock)) continue;
            return this.getStoneConvertedState(tool, convertedBlock);
        }
        return null;
    }

    private class_2680 getStoneConvertedState(class_1799 tool, class_2248 convertedBlock) {
        class_2680 state = convertedBlock.method_9564();
        if (tool.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES) || tool.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES) && !state.method_26164(ModTags.Blocks.STONE_STRATA3)) {
            return class_2246.field_10124.method_9564();
        }
        if (tool.method_31573(BTWRConventionalTags.Items.PRIMITIVE_PICKAXES) && (Integer)state.method_11654((class_2769)ConvertingBlock.BREAK_LEVEL) < 5) {
            return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(5));
        }
        if (tool.method_31573(BTWRConventionalTags.Items.MODERN_CHISELS) || tool.method_31573(BTWRConventionalTags.Items.ADVANCED_CHISELS)) {
            return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(3));
        }
        return (class_2680)state.method_11657((class_2769)ConvertingBlock.BREAK_LEVEL, (Comparable)Integer.valueOf(0));
    }

    private boolean shouldConvertOre(class_2680 state, class_1799 tool) {
        return !tool.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES) && (!tool.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES) || state.method_26164(ModTags.Blocks.DEEPSLATE_ORES));
    }

    private boolean isModernOrAdvancedChisel(class_1799 tool) {
        return tool.method_31573(BTWRConventionalTags.Items.MODERN_CHISELS) || tool.method_31573(BTWRConventionalTags.Items.ADVANCED_CHISELS);
    }
}

