/*
 * Decompiled with CFR 0.152.
 */
package org.tough_environment.item;

import btwr.btwr_sl.tag.BTWRConventionalTags;
import net.minecraft.class_1766;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.tough_environment.ToughEnvironmentMod;
import org.tough_environment.config.TESettings;
import org.tough_environment.tag.ModTags;

public class ItemMixinManager {
    @Unique
    private static final TESettings configChecker = ToughEnvironmentMod.getInstance().settings;
    private static final ItemMixinManager instance = new ItemMixinManager();

    private ItemMixinManager() {
    }

    public static ItemMixinManager getInstance() {
        return instance;
    }

    public void handleGetMiningSpeed(class_1799 stack, class_2680 state, CallbackInfoReturnable<Float> cir) {
        class_9424 toolComponent = (class_9424)stack.method_57824(class_9334.field_50077);
        if (stack.method_7909() instanceof class_1766) {
            assert (toolComponent != null);
            float originalSpeed = toolComponent.method_58425(state);
            if (this.isUnfeasibleToBreak(state, stack) && configChecker.isStratificationToughnessEnabled()) {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed / 8000.0f));
            } else if (this.isProblemToBreak(state, stack)) {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed / 80.0f));
            } else if (!this.isValidToolRequiringBlock(state) && this.isPrimitiveTool(stack) && !state.method_45474() && configChecker.isHardcorePlayerMiningSpeedEnabled()) {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed / 5.0f));
            } else if (this.isHoeWithCustomSpeed(stack)) {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed / this.getHoeSpeedModifier(stack)));
            } else if (state.method_26164(ModTags.Blocks.BROKEN_STONE_BLOCKS) && stack.method_7951(state)) {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed * 12.0f));
            } else {
                cir.setReturnValue((Object)Float.valueOf(originalSpeed));
            }
        }
    }

    private boolean isHoeWithCustomSpeed(class_1799 stack) {
        return stack.method_31573(class_3489.field_42613) && configChecker.isHardcorePlayerMiningSpeedEnabled();
    }

    private float getHoeSpeedModifier(class_1799 stack) {
        if (stack.method_31574(class_1802.field_8167)) {
            return 12.0f;
        }
        if (stack.method_31574(class_1802.field_8431)) {
            return 10.0f;
        }
        if (stack.method_31574(class_1802.field_8609)) {
            return 7.5f;
        }
        if (stack.method_31574(class_1802.field_8527)) {
            return 2.0f;
        }
        if (stack.method_31574(class_1802.field_22026)) {
            return 1.5f;
        }
        return 1.0f;
    }

    @Unique
    private boolean isProblemToBreak(class_2680 state, class_1799 stack) {
        boolean isStrata3 = state.method_26164(ModTags.Blocks.STONE_STRATA3);
        boolean isStrata2 = state.method_26164(ModTags.Blocks.STONE_STRATA2);
        boolean isStrata1 = state.method_26164(ModTags.Blocks.STONE_STRATA1);
        boolean isModernPickaxe = stack.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES);
        boolean isAdvancedPickaxe = stack.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES);
        if (isStrata3 && !isAdvancedPickaxe) {
            return true;
        }
        return isStrata2 && !isAdvancedPickaxe && !isModernPickaxe;
    }

    @Unique
    private boolean isUnfeasibleToBreak(class_2680 state, class_1799 stack) {
        if (state.method_26164(ModTags.Blocks.STONE_CONVERTING_STRATA3) && !stack.method_31573(BTWRConventionalTags.Items.ADVANCED_PICKAXES)) {
            return true;
        }
        return state.method_26164(ModTags.Blocks.STONE_CONVERTING_STRATA2) && !stack.method_31573(BTWRConventionalTags.Items.MODERN_PICKAXES);
    }

    @Unique
    private boolean isPrimitiveTool(class_1799 stack) {
        return stack.method_31573(BTWRConventionalTags.Items.PRIMITIVE_PICKAXES) || stack.method_31573(BTWRConventionalTags.Items.PRIMITIVE_AXES) || stack.method_31573(BTWRConventionalTags.Items.PRIMITIVE_SHOVELS) || stack.method_31573(BTWRConventionalTags.Items.PRIMITIVE_HOES) || stack.method_31573(BTWRConventionalTags.Items.PRIMITIVE_CHISELS);
    }

    private boolean isValidToolRequiringBlock(class_2680 state) {
        return state.method_29291() && this.isToughBlock(state);
    }

    private boolean isToughBlock(class_2680 state) {
        return state.method_26164(BTWRConventionalTags.Blocks.WEB_BLOCKS) || state.method_26164(BTWRConventionalTags.Blocks.STUMP_BLOCKS) || state.method_27852(class_2246.field_10477);
    }
}

