#version 130

uniform sampler2D texture;
uniform float rainStrength;

in vec2 TexCoords;

uniform int worldTime;

float state;

float smoothTransition(float time) {
    if (time >= 0.0f && time <= 1000.0f) {
        return time / 1000.0f; // Transition from 0 to 1
    } else if (time > 1000.0f && time < 12000.0f) {
        return 1.0f; // Fully enabled
    } else if (time >= 12000.0f && time <= 13000.0f) {
        return 1.0f - (time - 12000.0f) / 1000.0f; // Transition from 1 to 0
    } else {
        return 0.0f; // Fully disabled
    }
}

void main() {
	vec4 color = texture2D(texture, TexCoords);
	color.a *= 1 - rainStrength;

    state = smoothTransition(worldTime);

	/* DRAWBUFFERS:0 */
	gl_FragData[0] = color * (1 + state);
}