package com.alfakynz.nomorepopups.mixin;

import com.alfakynz.nomorepopups.config.ModConfig;
import net.minecraft.class_315;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_315.class)
public class MultiplayerMixin {

    @Inject(method = "load", at = @At("TAIL"))
    private void onLoad(CallbackInfo ci) {
        class_315 options = (class_315) (Object) this;
        if (ModConfig.INSTANCE.disableMultiplayerWarning) {
            options.field_21840 = true;
        }
    }

    @Inject(method = "save", at = @At("TAIL"))
    private void onWrite(CallbackInfo ci) {
        class_315 options = (class_315) (Object) this;
        if (ModConfig.INSTANCE.disableMultiplayerWarning) {
            options.field_21840 = true;
        }
    }
}