/*
 * Decompiled with CFR 0.152.
 */
package com.alfakynz.nomorepopups.config;

import com.alfakynz.nomorepopups.NoMorePopups;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/no-more-popups.json");
    public boolean disableAdvancementsMessages = false;
    public boolean disableAdvancementToasts = true;
    public boolean disableExperimentalWarning = true;
    public boolean disableMultiplayerWarning = true;
    public boolean disableRecipeToasts = true;
    public boolean disableResourcePackWarnings = true;
    public boolean disableTutorialToasts = true;
    public static ModConfig INSTANCE = new ModConfig();

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                NoMorePopups.LOGGER.error("Failed to load NMP config, using default values.", (Throwable)e);
                INSTANCE = new ModConfig();
            }
        } else {
            ModConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            NoMorePopups.LOGGER.error("Failed to save NMP config.", (Throwable)e);
        }
    }
}

