package com.alfakynz.nomorepopups.mixin;

import com.alfakynz.nomorepopups.config.ModConfig;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_634;
import net.minecraft.class_7417;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

/**
 * Mixin for removing advancement messages.
 */
@Mixin(class_634.class)
public class AdvancementMixin {

    @Inject(method = "handleSystemChat", at = @At("HEAD"), cancellable = true)
    private void onGameMessage(class_7439 packet, CallbackInfo ci) {
        if (ModConfig.INSTANCE.disableAdvancementsMessages) {
            class_2561 message = packet.comp_763();

            class_7417 content = message.method_10851();
            if (content instanceof class_2588 translatableContent) {
                String key = translatableContent.method_11022();
                if (key.startsWith("chat.type.advancement")) {
                    ci.cancel();
                }
            }
        }
    }
}