/*
 * Decompiled with CFR 0.152.
 */
package com.mars.stairstoblocks.mixin;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mars.deimos.datagen.DeimosRecipeGenerator;
import com.mars.stairstoblocks.StairsToBlocksConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class}, priority=900)
public class RecipeManagerMixin {
    @Inject(method={"prepare"}, at={@At(value="TAIL")})
    private void onRecipesLoaded(ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfoReturnable<RecipeMap> cir) {
        if (StairsToBlocksConfig.add_recipes_manually) {
            return;
        }
        TreeMap<ResourceLocation, JsonElement> rawJsonMap = new TreeMap<ResourceLocation, JsonElement>();
        String recipesPath = Registries.elementsDirPath((ResourceKey)Registries.RECIPE);
        Map allRecipeResources = resourceManager.listResources(recipesPath, rl -> rl.getPath().endsWith(".json"));
        for (ResourceLocation resourceLocation : allRecipeResources.keySet()) {
            Optional optRes = resourceManager.getResource(resourceLocation);
            if (optRes.isEmpty()) continue;
            try {
                BufferedReader reader = ((Resource)optRes.get()).openAsReader();
                try {
                    JsonElement je = JsonParser.parseReader((Reader)reader);
                    rawJsonMap.put(resourceLocation, je);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        for (Map.Entry entry : rawJsonMap.entrySet()) {
            String[] set;
            JsonElement je = (JsonElement)entry.getValue();
            if (!RecipeManagerMixin.hasStairsPattern(je) || (set = RecipeManagerMixin.extractKeyAndResult(je)) == null) continue;
            DeimosRecipeGenerator.createShapedRecipeJson((ArrayList)Lists.newArrayList((Object[])new Character[]{Character.valueOf('#')}), (ArrayList)Lists.newArrayList((Object[])new ResourceLocation[]{ResourceLocation.parse((String)set[set.length - 1])}), (ArrayList)Lists.newArrayList((Object[])new String[]{"item"}), (ArrayList)Lists.newArrayList((Object[])new String[]{"##", "##"}), (ResourceLocation)ResourceLocation.parse((String)set[0]), (int)StairsToBlocksConfig.block_amount);
        }
    }

    @Unique
    private static String[] extractKeyAndResult(JsonElement root) {
        JsonObject obj = root.getAsJsonObject();
        JsonArray pattArr = obj.getAsJsonArray("pattern");
        String row0 = pattArr.get(0).getAsString();
        char c = row0.charAt(0);
        String charKey = String.valueOf(c);
        if (!obj.has("key")) {
            return null;
        }
        JsonObject keyObj = obj.getAsJsonObject("key");
        if (!keyObj.has(charKey)) {
            return null;
        }
        JsonElement charEntry = keyObj.get(charKey);
        ArrayList<String> baseItems = new ArrayList<String>();
        if (charEntry.isJsonPrimitive()) {
            JsonPrimitive prim = charEntry.getAsJsonPrimitive();
            if (!prim.isString()) {
                return null;
            }
            baseItems.add(prim.getAsString());
        } else if (charEntry.isJsonArray()) {
            JsonArray arr = charEntry.getAsJsonArray();
            if (arr.size() == 0) {
                return null;
            }
            for (JsonElement elt : arr) {
                if (!elt.isJsonPrimitive()) {
                    return null;
                }
                JsonPrimitive p = elt.getAsJsonPrimitive();
                if (!p.isString()) {
                    return null;
                }
                baseItems.add(p.getAsString());
            }
        } else {
            return null;
        }
        if (!obj.has("result")) {
            return null;
        }
        JsonObject resObj = obj.getAsJsonObject("result");
        if (!resObj.has("id")) {
            return null;
        }
        JsonElement idElem = resObj.get("id");
        if (!idElem.isJsonPrimitive() || !((JsonPrimitive)idElem).isString()) {
            return null;
        }
        String resultId = idElem.getAsString();
        int total = baseItems.size() + 1;
        String[] output = new String[total];
        for (int i = 0; i < baseItems.size(); ++i) {
            output[i] = (String)baseItems.get(i);
        }
        output[total - 1] = resultId;
        return output;
    }

    @Unique
    private static boolean hasStairsPattern(JsonElement element) {
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has("pattern")) {
            return false;
        }
        JsonElement patternElem = obj.get("pattern");
        if (!patternElem.isJsonArray()) {
            return false;
        }
        JsonArray patternArray = patternElem.getAsJsonArray();
        if (patternArray.size() != 3) {
            return false;
        }
        String[] rows = new String[3];
        for (int i = 0; i < 3; ++i) {
            JsonElement rowElem = patternArray.get(i);
            if (!rowElem.isJsonPrimitive() || !((JsonPrimitive)rowElem).isString()) {
                return false;
            }
            rows[i] = rowElem.getAsString();
            if (rows[i].length() == 3) continue;
            return false;
        }
        char c = rows[0].charAt(0);
        if (c == ' ') {
            return false;
        }
        String expected0 = c + "  ";
        String expected1 = "" + c + c + " ";
        String expected2 = "" + c + c + c;
        return rows[0].equals(expected0) && rows[1].equals(expected1) && rows[2].equals(expected2);
    }
}

