/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import net.flare.el.commands.LoginCommand;
import net.flare.el.commands.RegisterCommand;
import net.flare.el.commands.ReloadCommand;
import net.flare.el.commands.ResetPasswordCommand;
import net.flare.el.config.ConfigManager;
import net.flare.el.database.SQLiteDataSource;
import net.flare.el.database.UserRepository;
import org.slf4j.Logger;

@Plugin(id="epiclogin", name="EpicLogin", version="1.0-SNAPSHOT", authors={"YourName"})
public class EpicLogin {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private ConfigManager configManager;
    private SQLiteDataSource dataSource;
    private UserRepository userRepository;

    @Inject
    public EpicLogin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        this.init();
    }

    private void init() {
        this.configManager = new ConfigManager(this.dataDirectory);
        this.logger.info("EpicLogin config loaded.");
        this.dataSource = new SQLiteDataSource(this.configManager.getDatabaseFile());
        this.userRepository = new UserRepository(this.dataSource);
        this.logger.info("EpicLogin database initialized.");
        CommandManager cm = this.server.getCommandManager();
        cm.register(cm.metaBuilder("register").plugin((Object)this).build(), (Command)new RegisterCommand(this.userRepository));
        cm.register(cm.metaBuilder("login").plugin((Object)this).build(), (Command)new LoginCommand(this.userRepository));
        cm.register(cm.metaBuilder("epiclogin").plugin((Object)this).aliases(new String[]{"el"}).build(), (Command)new ReloadCommand(this.configManager));
        cm.register(cm.metaBuilder("resetpassword").plugin((Object)this).build(), (Command)new ResetPasswordCommand(this.userRepository));
    }
}

