/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import net.flare.el.database.UserRepository;
import net.flare.el.utils.PasswordUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class RegisterCommand
implements SimpleCommand {
    private final UserRepository userRepository;

    public RegisterCommand(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage((Component)Component.text("Only players can register.", (TextColor)NamedTextColor.RED));
            return;
        }
        Player player = (Player)commandSource;
        String[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            player.sendMessage((Component)Component.text("Usage: /register <password>", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        if (this.userRepository.isRegistered(player.getUniqueId())) {
            player.sendMessage((Component)Component.text("You are already registered.", (TextColor)NamedTextColor.RED));
            return;
        }
        String hashed = PasswordUtils.hashPassword(args[0]);
        if (this.userRepository.register(player.getUniqueId(), player.getUsername(), hashed)) {
            player.sendMessage((Component)Component.text("Registration successful!", (TextColor)NamedTextColor.GREEN));
        } else {
            player.sendMessage((Component)Component.text("Registration failed.", (TextColor)NamedTextColor.RED));
        }
    }
}

