/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.commands;

import com.velocitypowered.api.command.SimpleCommand;
import net.flare.el.database.UserRepository;
import net.flare.el.utils.PasswordUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ResetPasswordCommand
implements SimpleCommand {
    private final UserRepository userRepository;

    public ResetPasswordCommand(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        if (!invocation.source().hasPermission("epiclogin.command.resetpassword")) {
            invocation.source().sendMessage((Component)Component.text("You do not have permission.", (TextColor)NamedTextColor.RED));
            return;
        }
        String[] args = (String[])invocation.arguments();
        if (args.length < 2) {
            invocation.source().sendMessage((Component)Component.text("Usage: /epiclogin resetpassword <player> <newpass>", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        String targetUsername = args[0];
        String newHash = PasswordUtils.hashPassword(args[1]);
        boolean result = this.userRepository.resetPassword(targetUsername, newHash);
        if (result) {
            invocation.source().sendMessage((Component)Component.text("Password for " + targetUsername + " has been reset.", (TextColor)NamedTextColor.GREEN));
        } else {
            invocation.source().sendMessage((Component)Component.text("Could not reset password for " + targetUsername + ".", (TextColor)NamedTextColor.RED));
        }
    }
}

