/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private Map<String, Object> config;
    private Properties messages;
    private final Path dataFolder;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ConfigManager(Path dataFolder) {
        this.dataFolder = dataFolder;
        this.reload();
    }

    public boolean reload() {
        boolean ok = true;
        Path configFile = this.dataFolder.resolve("config.yml");
        try (FileInputStream is = new FileInputStream(configFile.toFile());){
            Yaml yaml = new Yaml();
            this.config = (Map)yaml.load(is);
        }
        catch (Exception e) {
            ok = false;
            this.config = null;
            e.printStackTrace();
        }
        Path messageFile = this.dataFolder.resolve("messages.properties");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(messageFile.toFile()), StandardCharsets.UTF_8);){
            this.messages = new Properties();
            this.messages.load(reader);
        }
        catch (Exception e) {
            ok = false;
            this.messages = null;
            e.printStackTrace();
        }
        return ok;
    }

    public String getString(String path, String fallback) {
        if (this.config != null && this.config.containsKey(path)) {
            Object value = this.config.get(path);
            return value == null ? fallback : value.toString();
        }
        return fallback;
    }

    public String getDatabaseFile() {
        return this.getString("database.file", "plugins/EpicLogin/database.db");
    }

    public String getPermission(String key) {
        return this.getString("permissions." + key, "epiclogin.command." + key);
    }

    public String getRawMessage(String key, String fallback) {
        if (this.messages != null && this.messages.containsKey(key)) {
            return this.messages.getProperty(key);
        }
        return fallback;
    }

    public Component getMessage(String key, String fallback) {
        return this.miniMessage.deserialize(this.getRawMessage(key, fallback));
    }
}

